 /*
  * Khoros: $Id: vmcustom.c,v 1.1 1991/05/10 15:48:36 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmcustom.c,v 1.1 1991/05/10 15:48:36 khoros Exp $";
#endif

 /*
  * $Log: vmcustom.c,v $
 * Revision 1.1  1991/05/10  15:48:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmcustom.c
 >>>>
 >>>>      Program Name: vmcustom
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Customizes a morphological kernel via keyboard entry
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Sat Mar  9 08:25:23 1991
 >>>>
 >>>>          Routines: main- the main program for vmcustom
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmcustom.h"


/****************************************************************
 *
 * Routine Name:  main program for vmcustom
 *
 *       Input:  
 *          -o  output morphological kernel 
 *
 *
 *          [-r] specify the number of rows  (1 < value < 64)
 *          [-c] specify the number of columns  (1 < value < 64)
 *          [-x] specify x position of upper left  (-64 < value < 64)
 *          [-y] specify y position of upper left  (-64 < value < 64)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *kernel, *create_image();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvmcustom(&kernel,vmcustom->o_file,vmcustom->r_int,
           vmcustom->c_int,vmcustom->x_int,vmcustom->y_int))
    {
        (void) fprintf(stderr, "vmcustom: lvmcustom Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vmcustom->o_file,kernel);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmcustom 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmcustom :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCustomizes a morphological kernel via keyboard entry\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output morphological kernel  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  specify the number of rows (integer, 1 to 64) [3]\n");
	fprintf(stderr,"\t[-c]  specify the number of columns (integer, 1 to 64) [3]\n");
	fprintf(stderr,"\t[-x]  specify x position of upper left (integer, -64 to 64) [0]\n");
	fprintf(stderr,"\t[-y]  specify y position of upper left (integer, -64 to 64) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmcustom\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmcustom\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmcustom.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmcustom.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmcustom
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output morphological kernel \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) specify the number of rows \n        {integer, 1 to 64 [3] }: "; 
char	*c_pstr = 
	"\nEnter: (c) specify the number of columns \n        {integer, 1 to 64 [3] }: "; 
char	*x_pstr = 
	"\nEnter: (x) specify x position of upper left \n        {integer, -64 to 64 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) specify y position of upper left \n        {integer, -64 to 64 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmcustom", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmcustom.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmcustom: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmcustom.ans");
		}

	     }

	}

	/*
	 * allocate the vmcustom structure
	 */
	vmcustom = (vmcustom_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmcustom_struct));

	/*
	 * get required arguments for vmcustom
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmcustom->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmcustom->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmcustom->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmcustom->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmcustom->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmcustom
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmcustom->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vmcustom->r_int),
	3, 1, 64);

	vmcustom->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vmcustom->c_int),
	3, 1, 64);

	vmcustom->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vmcustom->x_int),
	0, -64, 64);

	vmcustom->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vmcustom->y_int),
	0, -64, 64);


}



