 /*
  * Khoros: $Id: vstereo.h,v 1.2 1991/12/18 09:30:55 dkhoros Exp $
  */

 /*
  * $Log: vstereo.h,v $
 * Revision 1.2  1991/12/18  09:30:55  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vstereo.h
 >>>>            Author: Pascal Adam
 >>>> Date Last Updated: Sat Dec 14 18:14:38 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vstereo_h_
#define _vstereo_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vstereo Argument Structure
*
****************************************************************/

typedef struct _vstereo  {

/*
 *  Input Matched Image (Required infile)
 */
char	*i_file;	/* Input Matched Image FILENAME */
int	 i_flag;	/* Input Matched Image FLAG */

/*
 *  Output Depth Image (Required outfile)
 */
char	*o_file;	/* Output Depth Image FILENAME */
int	 o_flag;	/* Output Depth Image FLAG */

/*
 *  Focal Length of the Camera (Optional float)
 */
float	 f_float;	/* Focal Length of the Camera FLOAT */
int	 f_flag;   	/* Focal Length of the Camera FLAG */

/*
 *  Image Length (CCD Sensor) (Optional float)
 */
float	 l_float;	/* Image Length (CCD Sensor) FLOAT */
int	 l_flag;   	/* Image Length (CCD Sensor) FLAG */

/*
 *  Image Height (CCD Sensor) (Optional float)
 */
float	 h_float;	/* Image Height (CCD Sensor) FLOAT */
int	 h_flag;   	/* Image Height (CCD Sensor) FLAG */

/*
 *  Camera Displacement on X Axis (Optional float)
 */
float	 d_float;	/* Camera Displacement on X Axis FLOAT */
int	 d_flag;   	/* Camera Displacement on X Axis FLAG */

/*
 *  Maximum Distance from camera (Optional float)
 */
float	 z_float;	/* Maximum Distance from camera FLOAT */
int	 z_flag;   	/* Maximum Distance from camera FLAG */

}  vstereo_struct;

vstereo_struct *vstereo;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
        image = readimage(vstereo->i_file); \
        if (image == NULL) \
        { \
            (void)fprintf(stderr,"vstereo: Cannot Read The Input Image \n"); \
            exit(1); \
        } 
#define CHECKINPUT(program, image) \
        if ((image->data_storage_type != VFF_TYP_1_BYTE) && \
            (image->data_storage_type != VFF_TYP_2_BYTE) && \
            (image->data_storage_type != VFF_TYP_4_BYTE)  ) \
        { \
            (void) fprintf(stderr,  \
"vstereo: can't accept the data storage type of the input image!\n\n"); \
            exit(1); \
        }; \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_num_bands(program,image,1,TRUE); \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE) 

/* -include_macros_end */

#endif
