 /*
  * Khoros: $Id: vect2band.h,v 1.1 1991/05/10 15:47:07 khoros Exp $
  */

 /*
  * $Log: vect2band.h,v $
 * Revision 1.1  1991/05/10  15:47:07  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vect2band.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Tue Mar  5 22:23:52 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vect2band_h_
#define _vect2band_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vect2band Argument Structure
*
****************************************************************/

typedef struct _vect2band  {

/*
 *  input (vector) data file (Required infile)
 */
char	*i_file;	/* input (vector) data file FILENAME */
int	 i_flag;	/* input (vector) data file FLAG */

/*
 *  output (image) file (Required outfile)
 */
char	*o_file;	/* output (image) file FILENAME */
int	 o_flag;	/* output (image) file FLAG */

}  vect2band_struct;

vect2band_struct *vect2band;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
        image = readimage(vect2band->i_file);  \
        if (image == NULL) {  \
        (void) fprintf(stderr, "vect2band: Can not read input image \n");  \
        exit(1);  /* Quit if bad image */ \
        } 

#define CHECKTYPE(program, image) \
   if (propertype(program, image, VFF_TYP_BIT, FALSE)) { \
       fprintf(stderr,"%s: data storage type must not be BIT.",program); \
       exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);
/* -include_macros_end */

#endif
