 /*
  * Khoros: $Id: vbandcomb.c,v 1.1 1991/05/10 15:46:50 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vbandcomb.c,v 1.1 1991/05/10 15:46:50 khoros Exp $";
#endif

 /*
  * $Log: vbandcomb.c,v $
 * Revision 1.1  1991/05/10  15:46:50  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbandcomb.c
 >>>>
 >>>>      Program Name: vbandcomb
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Combine all bands from m images into one multiband image
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer, Mark Young
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:22:45 1991
 >>>>
 >>>>          Routines: main- the main program for vbandcomb
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vbandcomb.h"


/****************************************************************
 *
 * Routine Name:  main program for vbandcomb
 *
 *       Input:  
 *           -o  output image filename 
 *
 *
 *           [-base] input basename
 *           [-i1] input image filename
 *           [-i2] input image filename
 *           [-i3] input image filename
 *           [-i4] input image filename
 *           [-i5] input image filename
 *           [-i6] input image filename
 *           [-i7] input image filename
 *           [-i8] input image filename
 *           [-i9] input image filename
 *           [-i10] input image filename
 *           [-m] map option 
 *		0 (ignore maps),
 *		1 (map data through map),
 *		or 2 (transfer maps)
 *		   [default = 0] 
 *           [-c] color space model
 *		0 (None),
 *		1 (ntscRGB),
 *		2 (ntscCMY),
 *		3 (ntscYIQ),
 *		4 (HSV),
 *		5 (HLS),
 *		6 (IHS),
 *		7 (cieRGB),
 *		8 (cieXYZ),
 *		9 (cieUVW),
 *		10 (cieucsUVW),
 *		11 (cieucsSOW),
 *		12 (cieucsLab),
 *		13 (cieucsLuv),
 *		14 (GENERIC),
 *		or 15 (genericRGB)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *readimage(), *newimage, **images;
int  i, num, up_type;
char **file_names, **vlistdir();
int  mode = XV_FILE | XV_PATH; 
char *program = "vbandcomb";
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

up_type = -1;       /* Set upcast mode to auto upcast to highest type */

if ( (vbandcomb->base_flag) && (vbandcomb->base_string != NULL) )
{

  /* Get list of filenames from vlistdir() */
  file_names = vlistdir(vbandcomb->base_string, NULL, mode, FALSE, &num);
  if (file_names == NULL)
  {
    (void) fprintf(stderr,"%s: Unable to get list of file names\n", program); 
    (void) fprintf(stderr,"from the supplied basename.\n"); 
    (void) fprintf(stderr,"vlistdir() was unable to return a list of files.\n"); 
    exit(1);
  }

  file_names = (char **) realloc(file_names, sizeof(char *) * (num + 10));
  if (file_names == NULL)
  {
    (void) fprintf(stderr,"%s: Unable to realloc space for file names\n",program);
    exit(1);
  }
}
else
{
  num = 0;
  file_names = (char **) malloc(sizeof(char *) * (num + 10));
  if (file_names == NULL)
  {
    (void) fprintf(stderr,"%s: Unable to malloc space for file names\n",program);
    exit(1);
  }
}
                          /* get space for image structures */
  images = (struct xvimage **) malloc(sizeof(struct xvimage *) * (num + 10));
  if (images == NULL)
  {
    (void) fprintf(stderr,"%s: Unable to malloc space for image structures\n",program);
    exit(1);
  }

  if (vbandcomb->i1_flag)
     file_names[num++] = vbandcomb->i1_file;

  if (vbandcomb->i2_flag)
     file_names[num++] = vbandcomb->i2_file;

                          /* Find out how many images there are. */
                              /* must have at least two input images */
  if (vbandcomb->i3_flag)     /* Now count the optional images */
     file_names[num++] = vbandcomb->i3_file;
  if (vbandcomb->i4_flag)
     file_names[num++] = vbandcomb->i4_file;
  if (vbandcomb->i5_flag)
     file_names[num++] = vbandcomb->i5_file;
  if (vbandcomb->i6_flag)
     file_names[num++] = vbandcomb->i6_file;
  if (vbandcomb->i7_flag)
     file_names[num++] = vbandcomb->i7_file;
  if (vbandcomb->i8_flag)
     file_names[num++] = vbandcomb->i8_file;
  if (vbandcomb->i9_flag)
     file_names[num++] = vbandcomb->i9_file;
  if (vbandcomb->i10_flag)
     file_names[num] = vbandcomb->i10_file;

  /* Error checking: 
   *  Ensure that at least two images are input to vbandcomb.
   */
  if (num < 2)
  {
    (void) fprintf(stderr,"%s: Requires at least two input images.\n", program);
    exit(1);
  }

  /* Read in first image, so we may match other images to the first. */ 
  if ((images[0] = readimage(file_names[0])) == NULL)
  {
     (void) fprintf(stderr, "%s: Can not read the input image, '%s'\n", program, file_names[0]);
     exit(1);  /* Quit if bad image */
  }
  (void) proper_num_images(program, images[0], 1, TRUE);


   /* if the any option arguments i3 - i10 were entered, then read the */
   /* image and check it against the first image */

   /* Ensure that data type is BYTE if data is to be mapped
    * through the color maps.
    */
   if (vbandcomb->m_toggle == 1) 
      propertype(program,images[0],VFF_TYP_1_BYTE,TRUE);


   /* Loop through all remaining file names and read input images.
    */
  for (i = 1; i < num; i++)
  {
    images[i] = readimage(file_names[i]);
    if (images[i] == NULL)
    {
       (void) fprintf(stderr, "%s: Can not read the input image, '%s'\n", program,file_names[i]);
       exit(1);  /* Quit if bad image */
    }
    if ( (match_num_images(program,images[0],images[i],FALSE) == 0) || (matchsize(program,images[0],images[i],FALSE) == 0) )
    {
       (void) fprintf(stderr,"%s: The file '%s' did not match the size of first image, '%s'\n", program, file_names[i], file_names[0]);
       exit(1);
    }
  }
              /* Call lvcast to upcast input images to same data type */
if (! lvcast(images, num, up_type) )
{
  (void) fprintf(stderr, "lvcast failed: could not upcast images.\n");
  exit(1);
}

/* -main_before_lib_call_end */

/* -main_library_call */
   /* call the lib */

if(! lvbandcomb(&newimage, images, num, vbandcomb->m_toggle, vbandcomb->c_toggle))
{
   (void) fprintf(stderr, "lvbandcomb Failed\n");
   exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(vbandcomb->o_file,newimage);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vbandcomb 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vbandcomb :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCombine all bands from m images into one multiband image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-base]  input basename (string) [null]\n");
	fprintf(stderr,"\t[-i1]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i2]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i3]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i4]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i5]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i6]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i7]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i8]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i9]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-i10]  input image filename (infile) [null]\n");
	fprintf(stderr, "\t[-m]  map option \n");
	fprintf(stderr, "\t\t0  (ignore maps),\n");
	fprintf(stderr, "\t\t1  (map data through map),\n");
	fprintf(stderr, "\t\tor 2  (transfer maps)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, "\t[-c]  color space model\n");
	fprintf(stderr, "\t\t0  (None),\n");
	fprintf(stderr, "\t\t1  (ntscRGB),\n");
	fprintf(stderr, "\t\t2  (ntscCMY),\n");
	fprintf(stderr, "\t\t3  (ntscYIQ),\n");
	fprintf(stderr, "\t\t4  (HSV),\n");
	fprintf(stderr, "\t\t5  (HLS),\n");
	fprintf(stderr, "\t\t6  (IHS),\n");
	fprintf(stderr, "\t\t7  (cieRGB),\n");
	fprintf(stderr, "\t\t8  (cieXYZ),\n");
	fprintf(stderr, "\t\t9  (cieUVW),\n");
	fprintf(stderr, "\t\t10  (cieucsUVW),\n");
	fprintf(stderr, "\t\t11  (cieucsSOW),\n");
	fprintf(stderr, "\t\t12  (cieucsLab),\n");
	fprintf(stderr, "\t\t13  (cieucsLuv),\n");
	fprintf(stderr, "\t\t14  (GENERIC),\n");
	fprintf(stderr, "\t\tor 15  (genericRGB)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vbandcomb\n");
	fprintf(stderr, "\t[-U] Gives the usage for vbandcomb\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vbandcomb.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vbandcomb.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vbandcomb
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*base_pstr = 
	"\nEnter: (base) input basename \n        {string}: "; 
char	*base_def = NULL;
char	*i1_pstr = 
	"\nEnter: (i1) input image filename \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image filename \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) input image filename \n        {infile}: "; 
char	*i4_pstr = 
	"\nEnter: (i4) input image filename \n        {infile}: "; 
char	*i5_pstr = 
	"\nEnter: (i5) input image filename \n        {infile}: "; 
char	*i6_pstr = 
	"\nEnter: (i6) input image filename \n        {infile}: "; 
char	*i7_pstr = 
	"\nEnter: (i7) input image filename \n        {infile}: "; 
char	*i8_pstr = 
	"\nEnter: (i8) input image filename \n        {infile}: "; 
char	*i9_pstr = 
	"\nEnter: (i9) input image filename \n        {infile}: "; 
char	*i10_pstr = 
	"\nEnter: (i10) input image filename \n        {infile}: "; 
char	*m_pstr = "\nEnter: (m) map option  -- \n      \t\t0 (ignore maps)\n\t\t1 (map data through map)\n\t\tor 2 (transfer maps)\n  [0]:  "; 
char	*c_pstr = "\nEnter: (c) color space model -- \n      \t\t0 (None)\n\t\t1 (ntscRGB)\n\t\t2 (ntscCMY)\n\t\t3 (ntscYIQ)\n\t\t4 (HSV)\n\t\t5 (HLS)\n\t\t6 (IHS)\n\t\t7 (cieRGB)\n\t\t8 (cieXYZ)\n\t\t9 (cieUVW)\n\t\t10 (cieucsUVW)\n\t\t11 (cieucsSOW)\n\t\t12 (cieucsLab)\n\t\t13 (cieucsLuv)\n\t\t14 (GENERIC)\n\t\tor 15 (genericRGB)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vbandcomb", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vbandcomb.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vbandcomb: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vbandcomb.ans");
		}

	     }

	}

	/*
	 * allocate the vbandcomb structure
	 */
	vbandcomb = (vbandcomb_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vbandcomb_struct));

	/*
	 * get required arguments for vbandcomb
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vbandcomb->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vbandcomb->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbandcomb->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vbandcomb->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vbandcomb->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vbandcomb
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vbandcomb->base_flag = vget_string(fid, prompt_flag,
	"-base", base_pstr, &(vbandcomb->base_string),
	base_def);

	if (prompt_flag == FALSE)
	{
	    if ((vbandcomb->base_flag == 1)&&(vbandcomb->base_string == NULL))
    	{
		fprintf(stderr, "vbandcomb:\n");
		fprintf(stderr, "you must specify a name following '-base'\n");
		gw_usage();
		exit(1);
		}
	}
	vbandcomb->i1_flag = vget_infile(fid, prompt_flag,
	"-i1", i1_pstr, &(vbandcomb->i1_file))
;

	vbandcomb->i2_flag = vget_infile(fid, prompt_flag,
	"-i2", i2_pstr, &(vbandcomb->i2_file))
;

	vbandcomb->i3_flag = vget_infile(fid, prompt_flag,
	"-i3", i3_pstr, &(vbandcomb->i3_file))
;

	vbandcomb->i4_flag = vget_infile(fid, prompt_flag,
	"-i4", i4_pstr, &(vbandcomb->i4_file))
;

	vbandcomb->i5_flag = vget_infile(fid, prompt_flag,
	"-i5", i5_pstr, &(vbandcomb->i5_file))
;

	vbandcomb->i6_flag = vget_infile(fid, prompt_flag,
	"-i6", i6_pstr, &(vbandcomb->i6_file))
;

	vbandcomb->i7_flag = vget_infile(fid, prompt_flag,
	"-i7", i7_pstr, &(vbandcomb->i7_file))
;

	vbandcomb->i8_flag = vget_infile(fid, prompt_flag,
	"-i8", i8_pstr, &(vbandcomb->i8_file))
;

	vbandcomb->i9_flag = vget_infile(fid, prompt_flag,
	"-i9", i9_pstr, &(vbandcomb->i9_file))
;

	vbandcomb->i10_flag = vget_infile(fid, prompt_flag,
	"-i10", i10_pstr, &(vbandcomb->i10_file))
;


	/*
	 * get optional toggles for vbandcomb
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vbandcomb->m_flag = vget_int(fid, prompt_flag,
		"-m", m_pstr, &(vbandcomb->m_toggle),
		0, 0, 0);

		if ((vbandcomb->m_toggle == 0 ) || 
		    (vbandcomb->m_toggle == 1 ) || 
		    (vbandcomb->m_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	    ok = FALSE;
	    while(!ok)
	    {
		vbandcomb->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(vbandcomb->c_toggle),
		0, 0, 0);

		if ((vbandcomb->c_toggle == 0 ) || 
		    (vbandcomb->c_toggle == 1 ) || 
		    (vbandcomb->c_toggle == 2 ) || 
		    (vbandcomb->c_toggle == 3 ) || 
		    (vbandcomb->c_toggle == 4 ) || 
		    (vbandcomb->c_toggle == 5 ) || 
		    (vbandcomb->c_toggle == 6 ) || 
		    (vbandcomb->c_toggle == 7 ) || 
		    (vbandcomb->c_toggle == 8 ) || 
		    (vbandcomb->c_toggle == 9 ) || 
		    (vbandcomb->c_toggle == 10 ) || 
		    (vbandcomb->c_toggle == 11 ) || 
		    (vbandcomb->c_toggle == 12 ) || 
		    (vbandcomb->c_toggle == 13 ) || 
		    (vbandcomb->c_toggle == 14 ) || 
		    (vbandcomb->c_toggle == 15 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vbandcomb->m_flag = vget_int(fid, prompt_flag,
		"-m", m_pstr, &(vbandcomb->m_toggle),
		0, 0, 0);

		if ((vbandcomb->m_toggle != 0 ) && 
		    (vbandcomb->m_toggle != 1 ) && 
		    (vbandcomb->m_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
		vbandcomb->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(vbandcomb->c_toggle),
		0, 0, 0);

		if ((vbandcomb->c_toggle != 0 ) && 
		    (vbandcomb->c_toggle != 1 ) && 
		    (vbandcomb->c_toggle != 2 ) && 
		    (vbandcomb->c_toggle != 3 ) && 
		    (vbandcomb->c_toggle != 4 ) && 
		    (vbandcomb->c_toggle != 5 ) && 
		    (vbandcomb->c_toggle != 6 ) && 
		    (vbandcomb->c_toggle != 7 ) && 
		    (vbandcomb->c_toggle != 8 ) && 
		    (vbandcomb->c_toggle != 9 ) && 
		    (vbandcomb->c_toggle != 10 ) && 
		    (vbandcomb->c_toggle != 11 ) && 
		    (vbandcomb->c_toggle != 12 ) && 
		    (vbandcomb->c_toggle != 13 ) && 
		    (vbandcomb->c_toggle != 14 ) && 
		    (vbandcomb->c_toggle != 15 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



