 /*
  * Khoros: $Id: lrfclass.c,v 1.1 1991/05/10 15:46:01 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lrfclass.c,v 1.1 1991/05/10 15:46:01 khoros Exp $";
#endif

 /*
  * $Log: lrfclass.c,v $
 * Revision 1.1  1991/05/10  15:46:01  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lrfclass.c
 >>>>
 >>>>      Program Name: lrfclass
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Classify  an  image  using  the  Localized  Receptive  Field
 >>>>	classifier.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer and Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Apr  9 08:35:38 1991
 >>>>
 >>>>          Routines: main- the main program for lrfclass
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "lrfclass.h"


/****************************************************************
 *
 * Routine Name:  main program for lrfclass
 *
 *       Input:  
 *          -i1  input image 
 *          -i2  cluster center image 
 *          -i3  cluster variance image 
 *          -i4  weight image 
 *          -o  classified image 
 *
 *
 *          [-b] Border Width  (0 < value < 100)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image,         /* input image */
                *cc_img,        /* cluster center image */
                *var_img,       /* cluster variance image */
                *wt_img,        /* weight image */
                *class_img,     /* classified image */
                *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

/* Read in INPUT image for processing */
READIMAGE1(image);
CHECKTYPE(program, image);
CHECKINPUT(program, image);

/* Read in CLUSTER CENTER image as input for initial LRF nodes */
READIMAGE2(cc_img);
CHECKTYPE(program, cc_img);
CHECKINPUT(program, cc_img);

/* Read in VARIANCE image to get trace for widths of LRF centers */
READIMAGE3(var_img);
CHECKTYPE(program, var_img);
CHECKINPUT(program, var_img);

/* Read in WEIGHT image to initialize the Single Layer Perceptron */
READIMAGE4(wt_img);
CHECKTYPE(program, wt_img);
CHECKINPUT(program, wt_img);

/* Check for proper number of bands in the cluster center image. */
if ( image->num_data_bands != (cc_img->num_data_bands - 1)) {
   fprintf(stderr,"lrfclass: The center/class image does not contain the correct\n");
   fprintf(stderr, "number of data_bands\n");
   fprintf(stderr, "Should have %d bands, but contains %d bands\n", (image->num_data_bands + 1), cc_img->num_data_bands);
   exit(1);
}
/* Check for proper number of bands in the variance image. */
if ( image->num_data_bands != var_img->num_data_bands) {
    fprintf(stderr, "lrfclass: The variance image does not contain the correct\n");
    fprintf(stderr, "number of data_bands\n");
    fprintf(stderr, "Should have %d bands, but contains %d bands\n", image->num_data_bands , var_img->num_data_bands);
    exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
if(! llrfclass (image, cc_img, var_img, wt_img, &class_img, lrfclass->b_int) )
{
  (void) fprintf(stderr, "llrfclass Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
/* Write out the classified image */
writeimage(lrfclass->o_file, class_img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for lrfclass 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "lrfclass :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tClassify  an  image  using  the  Localized  Receptive  Field\n");
	fprintf(stderr, "\tclassifier.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  cluster center image  (infile)\n");
	fprintf(stderr,"\t-i3  cluster variance image  (infile)\n");
	fprintf(stderr,"\t-i4  weight image  (infile)\n");
	fprintf(stderr,"\t-o  classified image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]  Border Width (integer, 0 to 100) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for lrfclass\n");
	fprintf(stderr, "\t[-U] Gives the usage for lrfclass\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called lrfclass.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses lrfclass.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for lrfclass
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) cluster center image \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) cluster variance image \n        {infile}: "; 
char	*i4_pstr = 
	"\nEnter: (i4) weight image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) classified image \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) Border Width \n        {integer, 0 to 100 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "lrfclass", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "lrfclass.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "lrfclass: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "lrfclass.ans");
		}

	     }

	}

	/*
	 * allocate the lrfclass structure
	 */
	lrfclass = (lrfclass_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (lrfclass_struct));

	/*
	 * get required arguments for lrfclass
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(lrfclass->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(lrfclass->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrfclass->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    lrfclass->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(lrfclass->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrfclass->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(lrfclass->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrfclass->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    lrfclass->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(lrfclass->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrfclass->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(lrfclass->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrfclass->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    lrfclass->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(lrfclass->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrfclass->i4_flag = vget_infile(fid, prompt_flag,
			"-i4", i4_pstr, &(lrfclass->i4_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrfclass->i4_flag))
		{
		    fprintf(stderr, "\t\ti4 is required, please re-enter: \n");
		    lrfclass->i4_flag = vget_infile(fid, prompt_flag,
		    "-i4", i4_pstr, &(lrfclass->i4_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i4' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrfclass->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(lrfclass->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrfclass->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    lrfclass->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(lrfclass->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for lrfclass
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	lrfclass->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(lrfclass->b_int),
	0, 0, 100);


}



