 /*
  * Khoros: $Id: lvsvpsf.c,v 1.2 1992/03/20 23:07:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvsvpsf.c,v 1.2 1992/03/20 23:07:57 dkhoros Exp $";
#endif

 /*
  * $Log: lvsvpsf.c,v $
 * Revision 1.2  1992/03/20  23:07:57  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvsvpsf.c
 >>>>
 >>>>      Program Name: vsvpsf
 >>>>
 >>>> Date Last Updated: Mon Jan  6 14:21:37 1992 
 >>>>
 >>>>          Routines: lvsvpsf - the library call for vsvpsf
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define MPIXEL(entry,component,map_col_size) ((component)*(map_col_size)+(entry))
#define VCALL(func) if(!func) { fprintf(stderr,"%s failed\n","func"); return(0); }
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvsvpsf - library call for vsvpsf
*
* Purpose:
*    
*    Perform restoration  of  general  space-variant  pointspread
*    functions
*    
*    

* Input:
*    
*    img            pointer to image to be restored.
*    
*    psf            pointer to quantized PSF image.
*    
*    thresh         threshold level for inverse filter (float).
*    
*    

* Output:
*    
*    img            contains the restored input  image.  The  original
*                   image is overwritten.
*    
*    

*
* Written By: Scott Wilson
*    
*    

****************************************************************/


/* -library_def */
int
lvsvpsf(img,psf,thresh)
struct xvimage *img,*psf;
float thresh;
/* -library_def_end */

/* -library_code */
  {
    int i,j,rows,cols,trows,tcols;
    struct xvimage *temp,*tpsf,*shift,*a,*b,*c,*d,*tmp;
    float *f,*f1,*f2,*map,*t;
    int *i1;
    cols = img->row_size;
    rows = img->col_size;

    temp = createimage(rows,cols,VFF_TYP_FLOAT,1,1,
                       "Temp image for vsvpsf",
                       0,0,VFF_MS_NONE,VFF_MAPTYP_NONE,
                       VFF_LOC_IMPLICIT,0);
    bzero(temp->imagedata,rows*cols*sizeof(float));
    t = (float *)(temp->imagedata);

    /* Form 1/2 image shift function */
    VCALL(lvimpulse(&shift,rows,cols,1,1,rows/2,cols/2,rows,cols));
    VCALL(lvconvert(shift,VFF_TYP_FLOAT,0,1,0.0,1.0,0));
    VCALL(lvfft(shift,NULL,1,&tmp,0,NULL,0,NULL,0));
    freeimage(shift);
    shift = tmp;
    
    /* Loop thru all of the PSFs, doing an space-invariant restoration
       on each one an merge the results */
    for (i=0; i<psf->map_col_size; i++)
      {
        /* Copy the i'th quantized PSF into the tpsf image */
        trows = (psf->map_row_size)/(psf->map_subrow_size);
        tcols = psf->map_subrow_size;
        tpsf = createimage(trows,tcols,
                       VFF_TYP_FLOAT,1,1,
                       "Temp PSF for vsvpsf",
                       0,0,VFF_MS_NONE,VFF_MAPTYP_NONE,
                       VFF_LOC_IMPLICIT,0);
        f = (float *)(tpsf->imagedata);
        map = (float *)(psf->maps);
        for (j=0; j<trows*tcols; j++)
          f[j] = map[MPIXEL(i,j,psf->map_col_size)];


        /* Copy the image to be restored */
        a = copyimage(img);

        /* Do the invariant restoration */
        VCALL(lvfft(a,NULL,1,&tmp,0,NULL,0,NULL,0));
        freeimage(a);
        a = tmp;
        VCALL(lvgconst(&b,rows,cols,VFF_TYP_FLOAT,0.0,0.0,1));
        VCALL(lvinsert(b,tpsf,(cols-tcols)/2,(rows-trows)/2,0.0,0.0));
        freeimage(tpsf); 
        tpsf = b; 
        VCALL(lvfft(tpsf,NULL,1,&tmp,0,NULL,0,NULL,0));
        freeimage(tpsf);
        tpsf = tmp;
        VCALL(lvmul(tpsf,shift,NULL,0,1));      /* Shift PSF to corner */
        VCALL(lvinverse(a,NULL,tpsf,0,thresh));
        freeimage(tpsf);       
        VCALL(lvfft(a,NULL,0,NULL,1,&tmp,0,NULL,1));
        freeimage(a);
        a = tmp;

        /* Scan the psf image to see which pixels in the temp
           image should get the results */
        i1 = (int *)(psf->imagedata);    
        f1 = (float *)(a->imagedata);
        for (j=0; j<rows*cols; j++) if (i1[j] == i) t[j] = f1[j];
        freeimage(a);
      }

    free(img->imagedata);
    img->imagedata = temp->imagedata;
    return(1);
  }
/* -library_code_end */
