 /*
  * Khoros: $Id: lvlpf.c,v 1.2 1992/03/20 23:06:31 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvlpf.c,v 1.2 1992/03/20 23:06:31 dkhoros Exp $";
#endif

 /*
  * $Log: lvlpf.c,v $
 * Revision 1.2  1992/03/20  23:06:31  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvlpf.c
 >>>>
 >>>>      Program Name: vlpf
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:47:33 1991 
 >>>>
 >>>>          Routines: lvlpf - the library call for vlpf
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvlpf - library call for vlpf
*
* Purpose:
*    
*    Perform a low-pass filtering operation on an  image  in  the
*    frequency domain.
*    
*    
* Input:
*    
*         1. image -- xvimage structure
*         2. order -- low-pass filter order;
*                     default value is 1
*         3. type -- low-pass filter type; if 0
*                    selects an exponential
*                    filter (default), if 1
*                    selects a butterworth filter
*         4. fcut -- cutoff frequency radius;
*                    default value is 0.5
*    
*    
* Output:
*    
*         1. image -- holds the result of the
*                     high-pass filtered image.
*    
*         image is used for both the input xvimage structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, Ramiro Jordan
*    18-Nov-90 Scott Wilson Changed cutoff to float from int!
*    
*    Scott Wilson - 27-Jan-91 - Removed FFT data processing code
*    
*    
****************************************************************/


/* -library_def */
int
lvlpf(image,order,type,fcut)
struct xvimage *image;
int  order,type;
float fcut;
/* -library_def_end */

/* -library_code */
{
    int   i,j,nr,nc;
    int   p;
    float *f,e,elpf(),blpf();
    float cutoff;

    nc = image->row_size;
    nr = image->col_size;

    if (nr > nc) cutoff = fcut*nr*0.5;
    else cutoff = fcut*nc*0.5;

    p = 0;
    f= (float *)(image->imagedata);

    for (i=0; i<nr; i++)             /* Rows of FFT */
      {
        /* Perform filter operation (multiplication) over the line */
        for (j=0; j<nc; j++)
          {
            switch (type)
              {
                case 0 : e = elpf(i,j,cutoff,nr,order);
                         break;
                case 1 : e = blpf(i,j,cutoff,nr,order);
                         break;
                default : fprintf(stderr,"lvlpf: Unknown filter type\n");
                          return(0);
                          break;
              }
            f[p] = f[p]*e; p++; /* Real part */
            f[p] = f[p]*e; p++; /* Imaginary part */
          }
      }
      return(1);
}

float
elpf(i,j,cutoff,n,order)
int i,j,n,order;
float cutoff;
/* Exponential lowpass filter */
  {
    int x,y;
    double f;

    x = (n/2)-j;
    y = (n/2)-i;
    f = sqrt((double)(x*x+y*y))/cutoff;
    if (order != 1) f = pow((double)f,(double)order);
    f = exp((-.347)*f);
    return((float)f);
  }

float
blpf(i,j,cutoff,n,order)
int i,j,n,order;
float cutoff;
/* Butterworth lowpass filter */
  {
    int x,y;
    double f;

    x = (n/2)-j;
    y = (n/2)-i;
    f = sqrt((double)(x*x+y*y))/cutoff;
    f = pow((double)f,(double)(2*order));
    f = 1.0 / (1.0 + 0.414*f);
    return((float)f);
  }
/* -library_code_end */
