 /*
  * Khoros: $Id: lvhstr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvhstr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvhstr.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvhstr.c
 >>>>
 >>>>      Program Name: vhstr
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:03:37 1991 
 >>>>
 >>>>          Routines: lvhstr - the library call for vhstr
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvhstr - library call for vhstr
*
* Purpose:
*    
*    Performs histogram stretching of a BYTE grey-level image
*    
*    
* Input:
*    
*    image          points to the input xvimage structure
*    
*    pneg           a flag set (equal 1) if a photonegative output  is
*                   desired.
*    
*    
* Output:
*    
*    image          points to the xvimage structure that contains  the
*                   result of the operation.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Replaced call to lvhremap with inline code. c.gage 2/25/91
*    
*    
****************************************************************/


/* -library_def */
int
lvhstr(image,pneg)
struct xvimage *image;
int   pneg;
/* -library_def_end */

/* -library_code */
{
    int  nc, nr, i, j;
    int  hist[256], lvinvert();
    int  lo, hi, klo, khi, thresh;
    unsigned char map[256],*p,*c;

    if (image->data_storage_type != VFF_TYP_1_BYTE)
    {
        (void) fprintf(stderr,"\n\nlvhstr:   ");
        (void) fprintf(stderr,"sorry can only operate on byte images.\n\n");
        return(0);
    }

    nc = image->col_size;
    nr = image->row_size;

    /* Form histogram */
    bzero(hist,256*sizeof(int));
    p = (unsigned char *)(image->imagedata);
    for (i=0; i<nr*nc; i++) hist[*p++]++;

    /* Find the histogram boundaries by locating the 1 percent levels */
    thresh = nc * nr * 0.01;
    lo  =  hi = -1;
    klo = khi = 0;
    for (i = 0; i < 256; i++)
      {
        klo += hist[i]; khi += hist[255-i];
        if (klo > thresh && lo == -1) lo = i;
        if (khi > thresh && hi == -1) hi = 255-i;
        if (lo != -1 && hi != -1) break;
      }

    /* Check to see if we have a reasonable contrast span. If not, re-do
       the bounds with a zero threshold. */
    if (hi == lo)
      {
        thresh = 0;
        lo  =  hi = -1;
        klo = khi = 0;
        for (i = 0; i < 256; i++)
          {
            klo += hist[i]; khi += hist[255-i];
            if (klo > thresh && lo == -1) lo = i;
            if (khi > thresh && hi == -1) hi = 255-i;
            if (lo != -1 && hi != -1) break;
          }
      } 

    /* If still have a zero span bound, quit */
    if (hi == lo)
      {
        (void)fprintf(stderr,"lvhstr: image has zero contrast span\n");
        return(0);
      }

    /* Re map the histogram */
    for (i = 0; i < 256; i++)
    {
        if (i < lo)
           map[i] = 0;
        else if (i > hi)
           map[i] = 255;
        else
           map[i] = 255*(i-lo)/(hi-lo);
    }

    /* Re-map the image */
    c = (unsigned char *)(image->imagedata);
    for (i = 0; i < nc; i++)
    {
        for (j = 0; j < nr; j++)
        {
            *c = map[*c];
             c++;
        }
    }

    if(pneg)
    {
        if( !lvinvert(image) )
        {
            (void) fprintf(stderr,"lvinvert Failed\n");
            return(0);
        }
    }

    return(1);
}
/* -library_code_end */
