#! /bin/csh -f

# 
#  Khoros: $Id: bldmanual.csh,v 1.3 1992/03/20 22:37:20 dkhoros Exp $
#

#
# $Log: bldmanual.csh,v $
# Revision 1.3  1992/03/20  22:37:20  dkhoros
# VirtualPatch5
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1990, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: bldmanual.csh                          <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros manual
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# Routine Name:    bldmanual.csh
#
# AUTHORS:      Tom Sauer
#
# DATE:         7/29/90
#
# DESCRIPTION: This is a shell script will build the khoros manual
#		for later printing
#

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

##### initialize variables #####

set PROMPT_FLAG  = 0
set ANSWER_FLAG = 0
set ANSWER_FILE = "bldmanual.ans"
set CR_ANSWER_FLAG = 0
set CR_ANSWER_FILE = "bldmanual.ans"
set NAME_IN_FLAG = 0
set NAME_IN_PROG_FLAG = 0
set NAME_OUT_FLAG = 0
set NAME_OUT_PROG_FLAG = 0
set args = ""
set new_prog_opts = ""
set prog_opts = ""
set alignment_off = 0

set TEMPDIR = /tmp

##### get arguments off the command line #####

while ($#argv)
	switch("$argv[1]")
            case -U:
                goto usage
                breaksw
	    case -V:
		echo ""
                echo "bldmanual:  Khoros Version: 1, Release: 0"
                echo ""
                exit (1)
                breaksw
            case -a:
                set ANSWER_FLAG = 1
                breaksw
            case -A:
                set CR_ANSWER_FLAG = 1
                breaksw
            case -P:
                set PROMPT_FLAG = 1
                breaksw
            case -i:
		set NAME_IN_FLAG = 1
                breaksw
            case -o:
		set NAME_OUT_FLAG = 1
		breaksw

	    case -[B-O]*:       * not valid swithces
            case -[Q-T]*:
            case -[V-Z]*:
	    case -[b]:
	    case -[d-h]*:
	    case -[j-n]*:
	    case -[p-z]*:
	        goto usage
	 	breaksw
	
	    default:
		if ($NAME_IN_FLAG) then
		   set NAME_IN_FLAG = 0
		   set NAME_IN_PROG = $argv[1]
		   set NAME_IN_PROG_FLAG = 1
		else if ($NAME_OUT_FLAG) then
		   set NAME_OUT_FLAG = 0
		   set NAME_OUT_PROG = $argv[1]
		   set NAME_OUT_PROG_FLAG = 1
	 	else
		   set new_prog_opts = "$new_prog_opts $argv[1]"
		endif
		breaksw

	endsw
	shift
end  

##### error check command line for -A #####

     if ($CR_ANSWER_FLAG) then
        if ( (! $PROMPT_FLAG) || ($NAME_IN_FLAG) || ($NAME_OUT_FLAG)) then
           echo "bldmanual: Must specify either the -P OR the -i and -o options"
           goto usage
        endif
     endif

##### error check command line (-i) and (-o) #####

   if (($NAME_IN_FLAG) || ($NAME_OUT_FLAG)) then
      echo "bldmanual: Must specify BOTH an input and output filename"
      goto usage
   endif

##### if (-a) option specified with answer file, use that #####

if ($ANSWER_FLAG) then
     if (-e $ANSWER_FILE) then
          source $ANSWER_FILE
     else
         echo ""
         echo "Could not find answer file: $ANSWER_FILE"
         echo ""
     endif
endif

# update the prog_opts arg with the additional new_prog_opts args

set prog_opts = "$prog_opts $new_prog_opts"



###
### check to see if prompt flag is set.
### if it is, prompt for name of program & config file 
###

if ($PROMPT_FLAG) then
     if (! $NAME_IN_PROG_FLAG ) then
	 while ( ! $NAME_IN_PROG_FLAG )
	      echo -n "name of manual file to process: "
              set val = $<
              if ($val != "") then
                   set NAME_IN_PROG = $val
                   set NAME_IN_PROG_FLAG = 1
                   set NAME_IN_FLAG = 1
              endif
          end
    endif
     if (! $NAME_OUT_PROG_FLAG ) then
	 while ( ! $NAME_OUT_PROG_FLAG )
	      echo -n "resulting processed manual file: "
              set val = $<
              if ($val != "") then
                   set NAME_OUT_PROG = $val
                   set NAME_OUT_PROG_FLAG = 1
                   set NAME_OUT_FLAG = 1
              endif
          end
    endif
endif

### check to see if user specified (-A) indicating that they wish 
### to create an answer file. If so, write out the current command line
### arguments to the answer file.  NOTE: if a previous .ans file already
### exists, it will be over-written.  

if ($CR_ANSWER_FLAG) then
     echo " " > $CR_ANSWER_FILE
     echo "# answer file for bldmanual: " >> $CR_ANSWER_FILE
     echo " " >> $CR_ANSWER_FILE
     echo "#! /bin/csh -f" >> $CR_ANSWER_FILE
     echo " " >> $CR_ANSWER_FILE
     echo 'set NAME_IN_PROG="'$NAME_IN_PROG'"' >> $CR_ANSWER_FILE
     echo 'set NAME_IN_PROG_FLAG=1' >> $CR_ANSWER_FILE
     echo 'set NAME_OUT_PROG="'$NAME_OUT_PROG'"' >> $CR_ANSWER_FILE
     echo 'set NAME_OUT_PROG_FLAG=1' >> $CR_ANSWER_FILE
     echo " " >> $CR_ANSWER_FILE
     echo "# end" >> $CR_ANSWER_FILE
     echo " " >> $CR_ANSWER_FILE
endif

if (! $NAME_IN_PROG_FLAG || ! $NAME_OUT_PROG_FLAG ) then
    echo ""
    echo "bldmanual: You must specify the input and output file name"
    echo ""
    goto usage
endif

#   end of command line stuff
#   Start of the real code

    onintr cleanup

    if (! -e $NAME_IN_PROG) then
       echo "the file '$NAME_IN_PROG' does not exist"
       exit 0
    endif

    touch $TEMPDIR/solist.$$
    grep "^.so" $NAME_IN_PROG | awk '{ print $2 }' >> $TEMPDIR/solist.$$
    set cmd = "s|KHOROS_HOME|$KHOROS_HOME|"
    sed -e $cmd < $TEMPDIR/solist.$$ >! $TEMPDIR/manlist.$$

     touch $TEMPDIR/awk.$$

     echo 'BEGIN {' >> $TEMPDIR/awk.$$
     echo '   foundsh = 0' >> $TEMPDIR/awk.$$
     echo '   flag = 0' >> $TEMPDIR/awk.$$
     echo '}' >> $TEMPDIR/awk.$$
     echo '{' >> $TEMPDIR/awk.$$
     echo '   if( $1 == ".TH" ) {' >> $TEMPDIR/awk.$$
     echo '   }' >> $TEMPDIR/awk.$$
     echo ' 	   else if( $1 == ".SH" ) {' >> $TEMPDIR/awk.$$
     echo ' 	      if( foundsh == 0 ) {' >> $TEMPDIR/awk.$$
     echo '              foundsh = 1' >> $TEMPDIR/awk.$$
     echo '              flag = 1' >> $TEMPDIR/awk.$$
     echo '           }' >> $TEMPDIR/awk.$$
     echo ' 	      else print $0' >> $TEMPDIR/awk.$$
     echo '    	   }' >> $TEMPDIR/awk.$$
     echo '  else if( flag ) flag = 0' >> $TEMPDIR/awk.$$
     echo '  else print $0'>> $TEMPDIR/awk.$$
     echo '}' >> $TEMPDIR/awk.$$


    foreach file ( `cat $TEMPDIR/manlist.$$` )
       set head = $file:h
       set tail = $file:t
       set newfile = `basename $tail .doc`
       if ($head/$newfile.doc == $file) then
          if (! -d $head/manual) then
             echo "bldmanual: the directory '$head/manual' does not exist"
             echo "Please create the directory '$head/manual' and rerun"
             echo "bldmanual"
             goto cleanup
          endif
          if (! -w $head/manual) then
             echo "bldmanual: you do not have permission to write"
             echo "in the directory '$head/manual'"
             echo "Please change the permissions on the directory '$head/manual'"
	     echo "and rerun bldmanual"
             goto cleanup
          endif
          awk -f $TEMPDIR/awk.$$ $file >! $head/manual/$newfile
        endif 
       end
    
    if (-e $NAME_OUT_PROG) then
       echo -n "bldmanual: The output file '$NAME_OUT_PROG' exits. Overwrite[y/n]? (y)? "
       set resp = $<
       if ($resp == 'n') then
          exit(0)
       endif
    endif

    /bin/rm -f $NAME_OUT_PROG >& /dev/null
    touch $NAME_OUT_PROG

    echo ".so $KHOROS_HOME/manual/utils/tmac.manual" >> $NAME_OUT_PROG

    echo $KHOROS_HOME > $TEMPDIR/tmp.$$
    set new = `sed -e "s/\//\\\//g" $TEMPDIR/tmp.$$`

    touch $TEMPDIR/sed.$$
    echo "/^\.so/s/KHOROS_HOME\(.*\)\/\(.*\).doc/$new\1\/manual\/\2/" >> $TEMPDIR/sed.$$
    sed -f $TEMPDIR/sed.$$ $NAME_IN_PROG > $TEMPDIR/pass1.$$

    touch $TEMPDIR/sed1.$$
    echo "/^\.so/s/KHOROS_HOME\(.*\)/$new\1/" >> $TEMPDIR/sed1.$$
    sed -f $TEMPDIR/sed1.$$ $TEMPDIR/pass1.$$ >> $NAME_OUT_PROG


    /bin/rm -f $TEMPDIR/solist.$$ $TEMPDIR/manlist.$$ $TEMPDIR/tmp.$$ \
               $TEMPDIR/sed.$$ $TEMPDIR/awk.$$ $TEMPDIR/pass1.$$ $TEMPDIR/sed1.$$

    exit 0
###
###    the usage statement for bldmanual
###

usage:
    echo ""
    echo "bldmanual: "
    echo ""
    echo "        This program will take the Khoros manual and"
    echo "        prepare it so that it may be formatted using roff."
    echo ""
    echo "        -i (input file) name of manual to build"
    echo "        -o (output file) name of resulting manual, ready to format"
    echo ""
    echo "        [-V] Gives the release and version number"
    echo "        [-U] Gives the usage for bldmanual"
    echo "        [-P] Prompts for command line options"
    echo "        [-A [file1]] Creates the answer file called bldmanual.ans or file1"
    echo "        [-a [file1]] Uses bldmanual.ans or file1 as the answer file"
    echo ""
    exit 0

cleanup:

    /bin/rm -f $TEMPDIR/solist.$$ $TEMPDIR/manlist.$$ $TEMPDIR/tmp.$$ \
               $TEMPDIR/sed.$$ $TEMPDIR/awk.$$ $TEMPDIR/pass1.$$ $TEMPDIR/sed1.$$
    exit 0
