 /*
  * Khoros: $Id: dcpad.c,v 1.2 1992/03/20 23:33:30 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dcpad.c,v 1.2 1992/03/20 23:33:30 dkhoros Exp $";
#endif

 /*
  * $Log: dcpad.c,v $
 * Revision 1.2  1992/03/20  23:33:30  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dcpad.c
 >>>>
 >>>>      Program Name: dcpad
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Constant Pad.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Donna Koechner, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Mon Feb 17 23:28:50 1992
 >>>>
 >>>>          Routines: main- the main program for dcpad
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dcpad.h"


/****************************************************************
 *
 * Routine Name:  main program for dcpad
 *
 *       Input:  
 *       -i  input data file (xviff file) 
 *       -o  resulting output file (xviff file) 
 *
 *
 *       [-l] length of file to be generated  (value > 0)
 *       [-p] number of constant values at the beginning of data sequence  (value >= 0)
 *       [-j] real constant value for padding 
 *       [-k] imaginary constant value for padding 
 *       [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    image = readimage(dcpad->i_file);  
    if (image == NULL) {  
       (void) fprintf(stderr, "dcpad: Can not read input image \n");  
       exit(1);  /* Quit if bad image */ 
    }

    proper_num_images(program,image,1,TRUE);  
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(!ldcpad(image,dcpad->l_int,dcpad->p_int,dcpad->j_float,dcpad->k_float,
                     dcpad->d_logic)) {
                (void) fprintf(stderr, "ldcpad Failed\n");
                exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dcpad->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dcpad 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dcpad :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Constant Pad.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-l]  length of file to be generated (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-p]  number of constant values at the beginning of data sequence (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-j]  real constant value for padding (float) [0]\n");
	fprintf(stderr,"\t[-k]  imaginary constant value for padding (float) [0]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dcpad\n");
	fprintf(stderr, "\t[-U] Gives the usage for dcpad\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dcpad.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dcpad.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dcpad
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*l_pstr = 
	"\nEnter: (l) length of file to be generated \n        {integer, > 0 [256] }: "; 
char	*p_pstr = 
	"\nEnter: (p) number of constant values at the beginning of data sequence \n        {integer, >= 0 [0] }: "; 
char	*j_pstr = 
	"\nEnter: (j) real constant value for padding \n        {float [0.000000] }: "; 
char	*k_pstr = 
	"\nEnter: (k) imaginary constant value for padding \n        {float [0.000000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dcpad", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dcpad.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dcpad: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dcpad.ans");
		}

	     }

	}

	/*
	 * allocate the dcpad structure
	 */
	dcpad = (dcpad_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dcpad_struct));

	/*
	 * get required arguments for dcpad
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dcpad->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dcpad->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dcpad->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dcpad->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dcpad->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dcpad->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dcpad->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dcpad->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dcpad->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dcpad->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dcpad
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dcpad->l_flag = vget_int(fid, prompt_flag,
	"-l", l_pstr, &(dcpad->l_int),
	256, 2, 2);

	dcpad->p_flag = vget_int(fid, prompt_flag,
	"-p", p_pstr, &(dcpad->p_int),
	0, 1, 1);

	dcpad->j_flag = vget_float(fid, prompt_flag,
	"-j", j_pstr, &(dcpad->j_float),
	0.000000, 3.000000, 3.000000);

	dcpad->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(dcpad->k_float),
	0.000000, 3.000000, 3.000000);

	dcpad->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dcpad->d_logic), 1);


}



