 /*
  * Khoros: $Id: dgsin.h,v 1.2 1992/03/20 23:16:26 dkhoros Exp $
  */

 /*
  * $Log: dgsin.h,v $
 * Revision 1.2  1992/03/20  23:16:26  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgsin.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Sat Feb 15 16:31:08 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dgsin_h_
#define _dgsin_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dgsin Argument Structure
*
****************************************************************/

typedef struct _dgsin  {

/*
 *  resulting image (Required outfile)
 */
char	*o_file;	/* resulting image FILENAME */
int	 o_flag;	/* resulting image FLAG */

/*
 *  input value file (xviff file) (Optional infile)
 */
char	*i_file;	/* input value file (xviff file) FILENAME */
int	 i_flag;	/* input value file (xviff file) FLAG */

/*
 *  number of data sets (Optional integer)
 */
int	 v_int; 	/* number of data sets INT */
int	 v_flag;	/* number of data sets FLAG */

/*
 *  number of points (Optional integer)
 */
int	 n_int; 	/* number of points INT */
int	 n_flag;	/* number of points FLAG */

/*
 *  sampling frequency (Optional float)
 */
float	 s_float;	/* sampling frequency FLOAT */
int	 s_flag;   	/* sampling frequency FLAG */

/*
 *  maximum signal level (Optional float)
 */
float	 m_float;	/* maximum signal level FLOAT */
int	 m_flag;   	/* maximum signal level FLAG */

/*
 *  signal frequency (Optional float)
 */
float	 f_float;	/* signal frequency FLOAT */
int	 f_flag;   	/* signal frequency FLAG */

/*
 *  phase  (Optional float)
 */
float	 p_float;	/* phase  FLOAT */
int	 p_flag;   	/* phase  FLAG */

/*
 *  initial delay (Optional integer)
 */
int	 b_int; 	/* initial delay INT */
int	 b_flag;	/* initial delay FLAG */

/*
 *  radians per pixel (0) or hertz (1) (Optional logical)
 */
int	 h_logic;	/* radians per pixel (0) or hertz (1) LOGIC */
int	 h_flag;  	/* radians per pixel (0) or hertz (1) FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * lets user choose data type of image (Optional string toggle - )
 */
char	*t_toggle;		/* lets user choose data type of image STRING TOGGLE */
int	 t_flag;		/* lets user choose data type of image FLAG */

}  dgsin_struct;

dgsin_struct *dgsin;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
