 /*
  * Khoros: $Id: dllatt.c,v 1.2 1992/03/20 23:30:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dllatt.c,v 1.2 1992/03/20 23:30:45 dkhoros Exp $";
#endif

 /*
  * $Log: dllatt.c,v $
 * Revision 1.2  1992/03/20  23:30:45  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dllatt.c
 >>>>
 >>>>      Program Name: dllatt
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D LMS Lattice Predictor Filter
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:26:17 1992
 >>>>
 >>>>          Routines: main- the main program for dllatt
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dllatt.h"


/****************************************************************
 *
 * Routine Name:  main program for dllatt
 *
 *       Input:  
 *        -i  input file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-s] number of stages for the filter   (value > 0)
 *        [-c] specify the convergence parameter  (0.000 < value < 1.000)
 *        [-j] scalar processing (0) or vector processing (1) (default)
 *        [-d] down vectors(0) or across bands(1) (default)
 *        [-g] type of output file to be created
 *		0 (choose error sequence (default)),
 *		1 (choose signal estimate sequence),
 *		or 2 (choose lattice filter coefficients)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int     stages, out_option, arith_type, procdir;
float   alpha;
char    *malloc();

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image);
CHECKTYPE(program,image);
CHECKTYPE(program,image);

alpha = dllatt->c_float;
stages = dllatt->s_int;
arith_type = dllatt->j_logic;
out_option = dllatt->g_toggle;
procdir = dllatt->d_logic;

/* -main_before_lib_call_end */

/* -main_library_call */

if(! ldllatt ( image, alpha, stages, arith_type, out_option, procdir ) )
        {
            (void) fprintf(stderr, "ldllatt Failed\n");
            exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dllatt->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dllatt 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dllatt :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D LMS Lattice Predictor Filter\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"g\" is the output file to be created:\n");
(void) fprintf(stderr,"\t\"g=0\" error sequence (default)\n");
(void) fprintf(stderr,"\t\"g=1\" signal estimate sequence\n");
(void) fprintf(stderr,"\t\"g=2\" lattice filter coefficient sequence\n");
(void) fprintf(stderr,"where \"j\" type of arithmetic to be used:\n");
(void) fprintf(stderr,"\t\"j=0\" scalar arithmetic \n");
(void) fprintf(stderr,"\t\"j=1\" vector arithmetic (default) \n\n");
(void) fprintf(stderr,"where \"d\" direction of processing:\n");
(void) fprintf(stderr,"\t\"d=0\" down vectors \n");
(void) fprintf(stderr,"\t\"d=1\" across bands (default)\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  number of stages for the filter  (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-c]  specify the convergence parameter (float,  0.000 to 1.000) [0.01]\n");
	fprintf(stderr,"\t[-j]  scalar processing (0) or vector processing (1) (default) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  down vectors(0) or across bands(1) (default) (boolean) [true]\n");
	fprintf(stderr, "\t[-g]  type of output file to be created\n");
	fprintf(stderr, "\t\t0  (choose error sequence (default)),\n");
	fprintf(stderr, "\t\t1  (choose signal estimate sequence),\n");
	fprintf(stderr, "\t\tor 2  (choose lattice filter coefficients)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dllatt\n");
	fprintf(stderr, "\t[-U] Gives the usage for dllatt\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dllatt.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dllatt.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dllatt
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of stages for the filter  \n        {integer, > 0 [1] }: "; 
char	*c_pstr = 
	"\nEnter: (c) specify the convergence parameter \n        {float,  0.000 to 1.000 [0.010000] }: "; 
char	*j_pstr = 
	"\nEnter: (j) scalar processing (0) or vector processing (1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) down vectors(0) or across bands(1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*g_pstr = "\nEnter: (g) type of output file to be created -- \n      \t\t0 (choose error sequence (default))\n\t\t1 (choose signal estimate sequence)\n\t\tor 2 (choose lattice filter coefficients)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dllatt", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dllatt.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dllatt: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dllatt.ans");
		}

	     }

	}

	/*
	 * allocate the dllatt structure
	 */
	dllatt = (dllatt_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dllatt_struct));

	/*
	 * get required arguments for dllatt
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dllatt->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dllatt->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dllatt->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dllatt->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dllatt->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dllatt->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dllatt->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dllatt->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dllatt->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dllatt->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dllatt
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dllatt->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dllatt->s_int),
	1, 2, 2);

	dllatt->c_flag = vget_float(fid, prompt_flag,
	"-c", c_pstr, &(dllatt->c_float),
	0.010000, 0.000000, 1.000000);

	dllatt->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dllatt->j_logic), 1);

	dllatt->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dllatt->d_logic), 1);


	/*
	 * get optional toggles for dllatt
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dllatt->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dllatt->g_toggle),
		0, 0, 0);

		if ((dllatt->g_toggle == 0 ) || 
		    (dllatt->g_toggle == 1 ) || 
		    (dllatt->g_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dllatt->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dllatt->g_toggle),
		0, 0, 0);

		if ((dllatt->g_toggle != 0 ) && 
		    (dllatt->g_toggle != 1 ) && 
		    (dllatt->g_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



