 /*
  * Khoros: $Id: read_compr.c,v 1.2 1991/12/18 09:57:00 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: read_compr.c,v 1.2 1991/12/18 09:57:00 dkhoros Exp $";
#endif

 /*
  * $Log: read_compr.c,v $
 * Revision 1.2  1991/12/18  09:57:00  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/************************************************************
*
*  MODULE NAME: read_compressed
*
*      PURPOSE: read_compressed is a modification of block_read
*
*        INPUT: 1.  fid   --  the file descriptor in which to read from
*		2.  input --  a character pointer where the bytes will be 
*			      read and stored to
*		3.  size --   an integer specifying the number of bytes to 
*			      to be read.
*
*       OUTPUT: exits if ever entered.
*
*
*   WRITTEN BY: Scott Wilson
*   Modified by: Rasure (saturday am on the 4th of march while it
*                        was snowing out)
*   Date: 22-April-89
*
*   Modified: 13-Apr-91 Scott Wilson - Force null-terminated string
*               handed to atoi().
*             13-Apr-91 Scott Wilson, Mark Young - Rearranged compress
*               command execution so that the Apollo will work.
*
*************************************************************/

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	
#include "vencode.h"

read_compressed(fd, data, size, image)
int fd;               /* File descriptor to read from */
char *data;           /* Pointer to data area */
int size;             /* Size of uncompressed data */
struct xvimage *image; /* Pointer to image header */
  {
    char *tmpfile;
    char command[255];
    char *buf;
    FILE *file;
    int fdtmp;
    int len,index,n;
    struct stat stbuf;

    /* See if the size happends to be zero - if so, just return. This
       is done to emulate the behavior of block_read(). */
    if (size == 0)
      {
        return(0);
      }

    /* Grab the first 8 bytes from the file descriptor and see if
       the data should be unencoded or just copied */
    if (block_read(fd,command,8) != 8)
      {
        fprintf(stderr,"read_compressed: couldn't read first 8 bytes!\n");
        return(0);
      }
    command[8] = 0;
    len = atoi(command);
    if (len == 0)
      {
        if (block_read(fd,data,size) != size)
          {
            fprintf(stderr,"read_compressed: Incorrect byte count!\n");
            return(0);
          }
        return(size);
      }
    else
      {
        /* Read the data */
        buf = malloc(len);
        if (buf == NULL)
          {
            fprintf(stderr,"read_compr: Not enough space for buffer!\n");
            return(0);
          }
        if (block_read(fd,buf,len) != len)
          {
            fprintf(stderr,"read_compr: Incorrect byte count on data block!\n");
            free(buf);
            return(0);
          }

        /* Spew it thru the decompress command */
	tmpfile=vtempnam("vrcXXXXXX");
        index = image->data_encode_scheme;
        sprintf(command,"%s > %s",uncompr_cmd[index],tmpfile);
        if ((file = popen(command, "w")) == NULL)
          {
            fprintf(stderr,"read_compressed: Unable to open process\n");
            free(buf);
            return(0);
          }
        if (fwrite(buf,1,len,file) != len)
          {
            fprintf(stderr,"read_compressed: Unable to write source data\n");
            pclose(file);
            free(buf);
            return(0);
          }
        pclose(file);
        free(buf);

        /* See what happened */
        stat(tmpfile,&stbuf);
        if (stbuf.st_size != size)
          {
            fprintf(stderr,"read_compr: Decoded data byte count incorrect!\n");
            kunlink(tmpfile);
            return(0);
          }
        fdtmp = kopen(tmpfile,O_RDONLY,0444);
        n = block_read(fdtmp,data,size);
        if (n != size)
          {
            fprintf(stderr,"read_compressed: Incorrect decoded byte count!\n");
            kclose(fdtmp);
            kunlink(tmpfile);
            return(0);
          }
        kclose(fdtmp);
        kunlink(tmpfile);
        return(size);
      }
  }
