 /*
  * Khoros: $Id: ap_comment.c,v 1.1 1991/05/10 15:41:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ap_comment.c,v 1.1 1991/05/10 15:41:35 khoros Exp $";
#endif

 /*
  * $Log: ap_comment.c,v $
 * Revision 1.1  1991/05/10  15:41:35  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	ap_comment.c
# 
# AUTHORS:	Donna Koechner
# 
# DATE:		4/30/90
# 
# DESCRIPTION:	Append to VIFF file comment field 
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	 	

/**************************************************************
*
* MODULE NAME: 	append_comment
*
*     PURPOSE:	append_comment appends the "new_stuff" string
*		to the existing comment field pointed to by
*		image_comment.  If the number of characters in 
*		new_stuff plus the size of the original comment
*		exceeds the maximum allowable field comment size,
*		the new_stuff string will be truncated to comply 
*		with the max comment size.
*
*       INPUT: 1. image_comment -- the VIFF file comment field
*
*	       2. new_stuff -- the string to be added to the comment field
*
*      OUTPUT: 1. image_comment --  the modified VIFF comment field
*
* CALLED FROM: 
*
* ROUTINES CALLED: none
*
**************************************************************/

append_comment(image_comment, new_stuff)

char *image_comment, *new_stuff;
{
      	int app_length, orig_length;

	/*
  	* Append the new_stuff comment to the image's comment field.
  	* Make sure the new_stuff comment plus the original comment 
  	* is not greater than 256, the size of the comment field.
  	*/

  	app_length = VStrlen(new_stuff);
  	orig_length = VStrlen(image_comment);
  	if ((app_length + orig_length) >= COMMENTLEN)
  	{
   	   /*
    	    * Compute the amount of the original comment field we can fit 
    	    * into the new image's comment field.  The result is stored in
    	    * app_length, which is really one less than the max since we need
    	    * to make room for the end of string character '\0'.
    	    */

    	app_length = COMMENTLEN - orig_length - 1;
    	(void) strncat(image_comment, new_stuff, app_length);
  	}
  	else
    	  (void) strcat(image_comment, new_stuff);
}
