 /*
  * Khoros: $Id: make_table.c,v 1.2 1991/10/02 00:33:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: make_table.c,v 1.2 1991/10/02 00:33:15 khoros Exp $";
#endif

 /*
  * $Log: make_table.c,v $
 * Revision 1.2  1991/10/02  00:33:15  khoros
 * HellPatch2
 *
  */ 

/******************************************************************

	Make Answer File Argument Pointer Table

	source filename:			make_table.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	make_table()

	description
	-----------

	  This routine makes a table of pointers, each element
	of which points to a successive argument that has been
	read from the answer file into a linked list.

******************************************************************/

#include "vgparm.h"

make_table()

{
	extern int num_args;
	extern ARG_ENTRY first,**arg_table;

	int size,i;
	ARG_ENTRY *p;

	size = num_args*sizeof(ARG_ENTRY *);

	if ( arg_table != NULL ) {
	    free(arg_table);
	    arg_table = NULL;
	}

	arg_table = (ARG_ENTRY **) malloc(size);
        if(arg_table == NULL) { 
            fprintf(stderr,"\nERROR-make_table cannot allocate more memory\n");
                  
            exit(1);
        }

	for (p=first.next,i=0;i<num_args;i++,p=p->next) {
		arg_table[i] = p;
	}
}
