 /*
  * Khoros: $Id: list_utils.c,v 1.2 1991/12/18 09:54:52 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: list_utils.c,v 1.2 1991/12/18 09:54:52 dkhoros Exp $";
#endif

 /*
  * $Log: list_utils.c,v $
 * Revision 1.2  1991/12/18  09:54:52  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "vgparm.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>     file name: list_utils.c				<<<<
   >>>>								<<<<
   >>>>   description: File Utility				<<<<
   >>>>								<<<<
   >>>>      routines: vmergelist()				<<<<
   >>>>      	       vsortlist()				<<<<
   >>>>      	       vcopylist()				<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/********************************************************
*
*  MODULE NAME: vmergelist
*
*     PURPOSE: This module is used to merge to lists into a
*	       single list.  Note that the entries in each list
*	       are not copied into the new list.  Simply put the
*	       new list will also point to those same entries in
*	       each list, but in a consecutive manner.  If the
*	       "copy_entries" is true then each entry will also be
*	       string copied.
*
*       INPUT:  list1        - the first list that is to be merged
*       	list2        - the second list that is to be merged
*		num1	     - the number of entries in the first list
*		num2	     - the number of entries in the second list
*		copy_entries - whether to malloc and copy each
*			       string entry.
*
*      OUTPUT:  none
*
* CALLED FROM:
*
* WRITTEN BY:  Mark Young
*
********************************************************/


char **vmergelist(list1, list2, num1, num2, copy_entries)

char **list1, **list2;
int  num1, num2;
int  copy_entries;
{
	int  i, num, indx = 0;
	char **temp;


	if (list1 == NULL && list2 == NULL)
	   return(NULL);

	num = num1+num2;
	temp = (char **) kcalloc(num, sizeof(char *));

	if (list1 != NULL)
	{
	   for (i = 0; i < num1; i++, indx++)
	   {
	      if (copy_entries == TRUE)
		 temp[indx] = VStrcpy(list1[i]);
	      else
		 temp[indx] = list1[i];
	   }
	}

	if (list2 != NULL)
	{
	   for (i = 0; i < num2; i++, indx++)
	   {
	      if (copy_entries == TRUE)
		 temp[indx] = VStrcpy(list2[i]);
	      else
		 temp[indx] = list2[i];
	   }
	}
	return(temp);
}



/********************************************************
*
*  MODULE NAME: vsortlist
*
*     PURPOSE: This module is used to sort a list.
*
*       INPUT:  list - the list that is to be sorted
*		num  - the number of entries in the list
*		duplicate_entries - whether to allow duplicate
*			entries.
*
*      OUTPUT:  none
*
* CALLED FROM:
*
* WRITTEN BY:  Mark Young
*
********************************************************/


char **vsortlist(list, num, duplicate_entries)

char **list;
int  num;
int  duplicate_entries;
{
	int	 i, j;
	register char  *temp;
	register int   sorted, compare;


	if (list == NULL)
	   return(NULL);

	for (i = 0; i < num; i++)
	{
	    sorted = TRUE;
	    for (j = 1; j < num - i; j++)
	    {
	        compare = strcmp(list[j-1], list[j]);
		if (compare > 0)
		{
		   temp = list[j-1];
		   list[j-1] = list[j];
		   list[j] = temp;
		   sorted = FALSE;
		}
		else if (compare == 0 && duplicate_entries == FALSE)
	        {
	        }
	     }
	     if (sorted == TRUE) break;
	}
	return(list);
}



/********************************************************
*
*  MODULE NAME: vcopylist
*
*     PURPOSE: This module is used to copy the input list
*	       and return a new list.  If the "copy_entries"
*	       is true then each entry will also be string
*	       copied.
*
*       INPUT:  list - the list that is to be sorted
*		num  - the number of entries in the list
*		copy_entries - whether to malloc and copy each
*			       string entry.
*
*      OUTPUT:  none
*
* CALLED FROM:
*
* WRITTEN BY:  Mark Young
*
********************************************************/


char **vcopylist(list, num, copy_entries)

char **list;
int  num;
int  copy_entries;
{
	char **temp;


	temp = vmergelist(list, NULL, num, 0, copy_entries);
	return(temp);
}
