 /*
  * Khoros: $Id: khoros.c,v 1.3 1991/12/18 09:54:47 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: khoros.c,v 1.3 1991/12/18 09:54:47 dkhoros Exp $";
#endif

 /*
  * $Log: khoros.c,v $
 * Revision 1.3  1991/12/18  09:54:47  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>    File Name:     khoros.c
 >>>>
 >>>>         Date:     Mon Apr 23 13:21:56 199
 >>>>
 >>>>     Routines:     khoros_init  - initializes image processing
 >>>>				       routines in the khoros system
 >>>>
 >>>>			khoros_close - closes image process routines
 >>>>				       in the khoros system
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


extern  char    *program;       /* the name of the program */
extern char     **av;
extern int      ac;

/****************************************************************
*
* Routine Name: khoros_init
*
* Purpose: initializes image processing routines in the khoros system
* Input:   none
* Output:  none
*
****************************************************************/

khoros_init()
{
	FILE *log_file;
	char *getenv(),*str;
	int  i, atoi();

	if ((khoros_home = getenv( "KHOROS_HOME" )) == NULL)
	{
	   fprintf(stderr,"Environmental variable KHOROS_HOME not set.\n");
	   exit(1);
	}

	if ((khoros_log = getenv("KHOROS_LOG")) != NULL)
	{
	   if ((log_file = fopen(khoros_log, "a+")) == NULL)
	   {
	      fprintf(stderr,"khoros_init: Couldn't write to log file \"%s\"\n",
			 khoros_log);
	      fflush(stderr);
	   }
	   else
	   {
	      fprintf(log_file,"\n");
	      for (i=0; i<ac; i++) fprintf(log_file,"%s ",av[i]);
	      fprintf(log_file,"\n");
	      fclose(log_file);
	   }
	}

	str = getenv("KHOROS_KEYWORDS");
	if (str == NULL)
	   khoros_keyword_file = VStrcpy(DEFAULT_KEYWORD_FILE);
	else
	   khoros_keyword_file = VStrcpy(str);

	khoros_keyword_list = NULL;


	str = getenv("KHOROS_TOOLBOX");
	if (str == NULL)
	   khoros_toolbox_file = VStrcpy(DEFAULT_TOOLBOX_FILE);
	else
	   khoros_toolbox_file = VStrcpy(str);

	khoros_toolbox_list = NULL;

	str = getenv("KHOROS_HOSTS");
	if (str == NULL)
	   khoros_hosts_file = NULL;
	else
	   khoros_hosts_file = VStrcpy(str);


	str = getenv("KHOROS_VERBOSE");
	if (str == NULL)
	   khoros_verbose = 0;
	else if (strcmp(str,"0") == 0 ||
		 strcmp(str,"off") == 0 ||
		 strcmp(str,"OFF") == 0 ||
		 strcmp(str,"NO") == 0 ||
		 strcmp(str,"no") == 0)
	   khoros_verbose = 0;
	else
	   khoros_verbose = 1;
}

/****************************************************************
*
* Routine Name: khoros_close
*
* Purpose: closes image processing routines in the khoros system
* Input:   none
* Output:  none
*
****************************************************************/

khoros_close()
{
	kcloseall();
	exit(0);
}
