 /*
  * Khoros: $Id: xvdisplay.h,v 1.2 1991/10/01 23:52:43 khoros Exp $
  */

 /*
  * $Log: xvdisplay.h,v $
 * Revision 1.2  1991/10/01  23:52:43  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                           <<<<
   >>>>      file: xvdisplay.h					  <<<<
   >>>>                                                           <<<<
   >>>>      contains:  all #defines, structures, and global      <<<<
   >>>>                 definitions used by the xvdisplay library <<<<
   >>>>                                                           <<<<
   >>>>      date:  2/24/89                                       <<<<
   >>>>                                                           <<<<
   >>>>      written by: Mark Young, Stephanie Hallett,           <<<<
   >>>>                  Danielle Argiro                          <<<<
   >>>>                                                           <<<<
   >>>>      modifications:                                      <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#ifndef _xvdisplay_h_
#define _xvdisplay_h_

#include "xvinclude.h"
#include "xvoverlay.h"
#include "XImage.h"

/*
 *  declarations for Xlib variables
 */
int       ncolors;
GC	  roi_gc, xvd_gc;

Cursor    display_cursor;
unsigned long xvd_black, xvd_white;

/*
 *  defines for autocoloring an image
 */
#define   XVD_RGB_CUBE      1
#define   XVD_RGB_TRIANGLE  2
#define   XVD_RGB_SPIRAL    3
#define   XVD_HLS_SPIRAL    4
#define   XVD_HSV_RINGS     5
#define   XVD_HLS_RINGS     6
#define   XVD_RGB_DISTANCE  7
#define   XVD_CIE_DIAGRAM   8
#define   XVD_DENSITY_SLICE 9
#define   XVD_GREYSCALE     10
#define   XVD_SA_PSEUDO     11
#define   XVD_RAINBOW       12
#define   XVD_INVERT        13
#define   XVD_INVERT_ORIG   14
#define   XVD_RANDOM        15
#define   XVD_ORIGINAL      16

/*
 *  misc string defines
 */
#define   MAXBUF        512

/*
 *  general utility #defines
 */
#ifndef MAX_INTEN
#define  MAX_INTEN      65535
#endif

#ifndef MAX_PIXELS
#define  MAX_PIXELS     256
#endif

/*
 *  structure holding information about the image currently displayed
 */
typedef struct _DisplayStructure
{
	char	    *name;
	Display     *display;
	Colormap    colormap;
	XVisualInfo *vinfo;
	Visual	    *visual;

	int	  private_colormap, read_only, shape_parent, truecolor;
	int	  depth, pixelmin, pixelmax, pixelnum, pixelalloc;

	struct	  xvimage *disp_image;
	struct	  xvimage *image, *shape,  *clip,  *overlay, *ovmask;
	XImage	  *ximage, *xshape, *xclip, *xoverlay, *icon_ximage;
	Pixmap	  pixmap, shape_mask, clip_mask, overlay_mask,
		  overlay_pixmap, icon_pixmap;

	Widget    toplevel;
	Widget    icon;
	Widget    raster;
	Widget    position;

	XColor    xcolors[MAX_PIXELS];
	Boolean	  active[MAX_PIXELS];
	unsigned  long histogram[MAX_PIXELS], histmin, histmax;

} DisplayStructure;

/*
 *  function declarations
 */
void		  xvd_update_position();
DisplayStructure *xvd_create_xvdisplay(); 
DisplayStructure *xvd_create_image(); 
DisplayStructure *xvd_init_xvdisplay(); 
DisplayStructure *xvd_init_image(); 
struct xvimage   *xvd_extract_roi();

Pixmap		 xvd_create_pixmap();
XImage		 *xvd_create_ximage();
XImage		 *xvd_shrink_ximage();

XtErrorHandler   xvd_xt_error_handler(), xvd_xt_warning_handler();
int		 xvd_error_handler(), xvd_io_error_handler();

#endif /* _xvdisplay_h_ */
/* Do not add after this line */
