#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>
#include <conio.h>
#include <bios.h>
#include <signal.h>
#include <float.h>

#define false 0
#define true (!false)

#define BCOLOR BLUE
#define FCOLOR MAGENTA
#define HBCOLOR h_bcolor
#define HVCOLOR h_fcolor
#define VCOLOR WHITE

extern int h_bcolor;
extern int h_fcolor;
extern int noscreenio;

int gle_abort(char *s);
int graphmode(void);
int hpgl_initstr(void);

scr_refresh()
{
}
int scr_getch()
{
}
void exitcode(int i,int j);
void exitcode_c(int i,int j);
void exitcodef(int i,int j);
scr_init()
{
	signal(SIGFPE,exitcodef);

	signal(SIGABRT,exitcode);
	signal(SIGILL,exitcode);
	signal(SIGINT,exitcode_c);
	signal(SIGSEGV,exitcode);
	signal(SIGTERM,exitcode);
}
int d_tidyup(void);
extern int abort_flag;
void exitcode_c(int i, int j)
{
	static char etxt[60];
	printf("Abort key\n");
	abort_flag = true;
	signal(SIGINT,exitcode_c);
}
abort_key(void)
{
	int c;
	if (abort_flag) return true;
	if (kbhit()) {
		c = bioskey(1);
		c = c & 0xff;
		if (c==27) {getch(); abort_flag = true; return true;}
	}
	return false;
}
void exitcode(int i, int j)
{
	static char etxt[60];
	d_tidyup();
	sprintf(etxt,"Exit handler called %d %d \n",i,j);
	gle_abort(etxt);
}
void exitcodef(int i, int j)
{
	d_tidyup();
	printf("Floating point error %d %d \n",i,j);
	if (j==FPE_ZERODIVIDE) gle_abort("Divide by zero \n");
	if (j==FPE_INTDIV0) gle_abort("Interger Divide by zero \n");
	if (j==FPE_OVERFLOW) gle_abort("Numeric overflow \n");
	gle_abort("Floating point Exit handler called");
}
scr_end()
{
}
struct text_info r;
void *screensave;
screen_save()
{
	if (noscreenio) return;
	gettextinfo(&r);
	screensave = malloc(25*80*2);
	if (screensave==NULL) return;
	gettext(1,1,80,25,screensave);
}
screen_restore()
{
	if (noscreenio) return;
	if (screensave==NULL) return;
	puttext(1,1,80,25,screensave);
	free(screensave);
	screensave = NULL;
	textattr(r.attribute);
	window(r.winleft,r.wintop,r.winright,r.winbottom);
	gotoxy(r.curx,r.cury);
}
scr_savexy()
{
	if (noscreenio) return;
	gettextinfo(&r);
}
scr_left(int i)
{
	if (noscreenio) return;
	gotoxy(wherex()-i,wherey());
}
scr_right(int i)
{
	if (noscreenio) return;
	gotoxy(wherex()+i,wherey());
}
scr_restorexy()
{
	if (noscreenio) return;
	textattr(r.attribute);
	window(r.winleft,r.wintop,r.winright,r.winbottom);
	gotoxy(r.curx,r.cury);
}
scr_gets(char *x)
{
	gets(x);
}

extern int scr_blackwhite;
scr_norm()  /* yellow on blue */
{
	if (noscreenio) return;
	if (scr_blackwhite) {
		textcolor(WHITE); textbackground(BLACK);
	} else {
		textcolor(YELLOW); textbackground(BLUE);
	}
}
int scr_grey(void);
scr_menuhi()
{
	if (noscreenio) return;
	scr_grey();
}
scr_menuval()
{
	if (noscreenio) return;
	textcolor(WHITE); textbackground(BLUE);
}
scr_menubg()
{
	if (noscreenio) return;
	textcolor(YELLOW); textbackground(BLUE);
}
scr_inv()   /* black on white */
{
	if (noscreenio) return;
	textcolor(WHITE); textbackground(BLACK);
}
scr_grey()  /* black on grey */
{
	if (noscreenio) return;
	textcolor(BLACK); textbackground(LIGHTGRAY);
}
scr_isblackwhite()
{
	char *s;
	s = getenv("CGLE_BLACKWHITE");
	if (s!=NULL) return true;
	else return false;
}
vax_edt(char *s)
{
}
char *getsymbol(char *s)
{
	static char ss[100];
	ss[0] = 0;
	if ( getenv(s) != NULL) strcpy(ss,getenv(s));
	return ss;
}



