        SUBROUTINE  NNT
     *     (N, R,C, IL,JL,L, D, IU,JU,U, Z, B, TMP)                       ND 679
C                                                                         ND 680
C       INPUT VARIABLES:   N, R,C, IL,JL,L, D, IU,JU,U, B                 ND 681
C       OUTPUT VARIABLES:  Z                                              ND 682
C                                                                         ND 683
C       PARAMETERS USED INTERNALLY:                                       ND 684
C FIA   \ TMP   - HOLDS NEW RIGHT-HAND SIDE B' FOR SOLUTION OF THE        ND 685
C       \           EQUATION LX = B'.                                     ND 686
C       \           SIZE = N.                                             ND 687
C                                                                         ND 688
        INTEGER  R(1), C(1),  IL(1), JL(1),  IU(1), JU(1)                 ND 689
C       REAL  L(1), D(1), U(1),  Z(1), B(1),  TMP(1), TMPK                ND 690
        DOUBLE PRECISION  L(1), D(1), U(1),  Z(1), B(1),  TMP(1), TMPK    ND 691
C                                                                         ND 692
C  ******  SOLVE  UT Y = B  BY FORWARD SUBSTITUTION  *******************  ND 693
        DO 1 K=1,N                                                        ND 694
   1      TMP(K) = B(C(K))                                                ND 695
        DO 3 K=1,N                                                        ND 696
          TMPK = - TMP(K)                                                 ND 697
          JMIN = IU(K)                                                    ND 698
          JMAX = IU(K+1) - 1                                              ND 699
          IF (JMIN.GT.JMAX)  GO TO 3                                      ND 700
          DO 2 J=JMIN,JMAX                                                ND 701
   2        TMP(JU(J)) = TMP(JU(J)) + U(J) * TMPK                         ND 702
   3      CONTINUE                                                        ND 703
C                                                                         ND 704
C  ******  SOLVE  D LT X = Y  BY BACK SUBSTITUTION  ********************  ND 705
        K = N                                                             ND 706
        DO 6 I=1,N                                                        ND 707
          TMPK = - TMP(K) * D(K)                                          ND 708
          JMIN = IL(K)                                                    ND 709
          JMAX = IL(K+1) - 1                                              ND 710
          IF (JMIN.GT.JMAX)  GO TO 5                                      ND 711
          DO 4 J=JMIN,JMAX                                                ND 712
   4        TMP(JL(J)) = TMP(JL(J)) + L(J) * TMPK                         ND 713
   5      Z(R(K)) = - TMPK                                                ND 714
   6      K = K-1                                                         ND 715
        RETURN                                                            ND 716
        END                                                               ND 717
