        SUBROUTINE  NNF
     *     (N, R,C,IC, IA,JA,A, Z, B, IL,JL,L,LMAX, D, IU,JU,U,UMAX,      ND 523
     *      ROW, TMP, FLAG)                                               ND 524
C                                                                         ND 525
C       INPUT VARIABLES:   N, R,C,IC, IA,JA,A, B, IL,JL,LMAX, IU,JU,UMAX  ND 526
C       OUTPUT VARIABLES:  Z, L,D,U, FLAG                                 ND 527
C                                                                         ND 528
C       PARAMETERS USED INTERNALLY:                                       ND 529
C FIA   \ ROW   - HOLDS INTERMEDIATE VALUES IN CALCULATION OF L, D, U.    ND 530
C       \           SIZE = N.                                             ND 531
C FIA   \ TMP   - HOLDS NEW RIGHT-HAND SIDE B' FOR SOLUTION OF THE        ND 532
C       \           EQUATION  UX = B'.                                    ND 533
C       \           SIZE = N.                                             ND 534
C                                                                         ND 535
        INTEGER  R(1), C(1), IC(1),  IA(1), JA(1),                        ND 536
     *     IL(1), JL(1), LMAX,  IU(1), JU(1), UMAX,  FLAG                 ND 537
C       REAL  A(1), Z(1), B(1),  L(1), D(1), U(1),                        ND 538
C    *     ROW(1), TMP(1),  LI, SUM, DK                                   ND 539
        DOUBLE PRECISION  A(1), Z(1), B(1),  L(1), D(1), U(1),            ND 540
     *     ROW(1), TMP(1),  LI, SUM, DK                                   ND 541
C                                                                         ND 542
C  ******  CHECK STORAGE  **********************************************  ND 543
        IF (IL(N+1)-1 .GT. LMAX)  GO TO 104                               ND 544
        IF (IU(N+1)-1 .GT. UMAX)  GO TO 107                               ND 545
C                                                                         ND 546
C  ******  FOR EACH ROW  ***********************************************  ND 547
        DO 10 K=1,N                                                       ND 548
C  ******  SET THE INITIAL STRUCTURE OF ROW  ***************************  ND 549
          JMIN = IL(K)                                                    ND 550
          JMAX = IL(K+1) - 1                                              ND 551
          IF (JMIN.GT.JMAX)  GO TO 2                                      ND 552
C  ******  IF L(K,M) .NE. 0, ROW(M)=0  *********************************  ND 553
          DO 1 J=JMIN,JMAX                                                ND 554
   1        ROW(JL(J)) = 0                                                ND 555
   2      ROW(K) = 0                                                      ND 556
          JMIN = IU(K)                                                    ND 557
          JMAX = IU(K+1) - 1                                              ND 558
          IF (JMIN.GT.JMAX)  GO TO 4                                      ND 559
C  ******  IF U(K,M) .NE. 0, ROW(M)=0  *********************************  ND 560
          DO 3 J=JMIN,JMAX                                                ND 561
   3        ROW(JU(J)) = 0                                                ND 562
   4      JMIN = IA(R(K))                                                 ND 563
          JMAX = IA(R(K)+1) - 1                                           ND 564
C  ******  SET ROW TO KTH ROW OF REORDERED A  **************************  ND 565
          DO 5 J=JMIN,JMAX                                                ND 566
   5        ROW(IC(JA(J))) = A(J)                                         ND 567
C  ******  INITIALIZE SUM  *********************************************  ND 568
          SUM = B(R(K))                                                   ND 569
C                                                                         ND 570
C  ******  ASSIGN THE KTH ROW OF L AND ADJUST ROW, SUM  ****************  ND 571
          IMIN = IL(K)                                                    ND 572
          IMAX = IL(K+1) - 1                                              ND 573
          IF (IMIN.GT.IMAX)  GO TO 8                                      ND 574
          DO 7 I=IMIN,IMAX                                                ND 575
            LI = - ROW(JL(I))                                             ND 576
C  ******  IF L IS NOT REQUIRED, THEN COMMENT OUT THE FOLLOWING LINE  **  ND 577
            L(I) = - LI                                                   ND 578
            SUM = SUM + LI * TMP(JL(I))                                   ND 579
            JMIN = IU(JL(I))                                              ND 580
            JMAX = IU(JL(I)+1) - 1                                        ND 581
            IF (JMIN.GT.JMAX)  GO TO 7                                    ND 582
            DO 6 J=JMIN,JMAX                                              ND 583
   6          ROW(JU(J)) = ROW(JU(J)) + LI * U(J)                         ND 584
   7        CONTINUE                                                      ND 585
C                                                                         ND 586
C  ******  ASSIGN DIAGONAL D AND KTH ROW OF U, SET TMP(K)  *************  ND 587
   8      IF (ROW(K).EQ.0)  GO TO 108                                     ND 588
          DK = 1 / ROW(K)                                                 ND 589
          D(K) = DK                                                       ND 590
          TMP(K) = SUM * DK                                               ND 591
          JMIN = IU(K)                                                    ND 592
          JMAX = IU(K+1) - 1                                              ND 593
          IF (JMIN.GT.JMAX)  GO TO 10                                     ND 594
          DO 9 J=JMIN,JMAX                                                ND 595
   9        U(J) = ROW(JU(J)) * DK                                        ND 596
  10      CONTINUE                                                        ND 597
C                                                                         ND 598
C  ******  SOLVE  UX = TMP  BY BACK SUBSTITUTION  **********************  ND 599
        K = N                                                             ND 600
        DO 13 I=1,N                                                       ND 601
          SUM = TMP(K)                                                    ND 602
          JMIN = IU(K)                                                    ND 603
          JMAX = IU(K+1) - 1                                              ND 604
          IF (JMIN.GT.JMAX)  GO TO 12                                     ND 605
          DO 11 J=JMIN,JMAX                                               ND 606
  11        SUM = SUM - U(J) * TMP(JU(J))                                 ND 607
  12      TMP(K) = SUM                                                    ND 608
          Z(C(K)) = SUM                                                   ND 609
  13      K = K-1                                                         ND 610
C                                                                         ND 611
        FLAG = 0                                                          ND 612
        RETURN                                                            ND 613
C                                                                         ND 614
C ** ERROR:  INSUFFICIENT STORAGE FOR L                                   ND 615
 104    FLAG = 4*N + 1                                                    ND 616
        RETURN                                                            ND 617
C ** ERROR:  INSUFFICIENT STORAGE FOR U                                   ND 618
 107    FLAG = 7*N + 1                                                    ND 619
        RETURN                                                            ND 620
C ** ERROR:  ZERO PIVOT                                                   ND 621
 108    FLAG = 8*N + K                                                    ND 622
        RETURN                                                            ND 623
        END                                                               ND 624
