/*
Compute Jacobian and value of nonlinear eq (f^r(x) - x - xoffset)
by finite difference method
-----------------------------
NOTE:	nonlinear equations are not handled in periodic coords
Input:	r=period of an orbit, n=phase space dimension,
	x[n],x2[n] = coords of two current guesses
Output:	alpha[n][n]=DF(x) (Jacobian), beta[n]=F(x)
*/

void usrfun2(x,x2,alpha,beta,r,n)
double *x,*x2,**alpha,*beta;
int r,n;
{
	int i,k;
	extern double *t_va,*t_vf,*xoffset;

	/* xoffset need to be installed later */
	for(i=0;i<n;i++) xoffset[i] = 0;

	/* F(x) */
	for(i=0;i<n;i++) t_vf[i] = x[i];
	fmap_user(t_vf,r,n);
	for(i=0;i<n;i++) t_va[i] = t_vf[i]-x[i] - xoffset[i];

	/* DF(x) by finite difference */
	for(k=0;k<n;k++){
		for(i=0;i<n;i++) t_vf[i] = x[i];
		t_vf[k] = x2[k];
		fmap_user(t_vf,r,n);
		/* dist = f^r(x) - x - xoffset */
		for(i=0;i<n;i++){
			if(i==k)
				t_vf[i] -= (x2[i] + xoffset[i]);
			else
				t_vf[i] -= (x[i] + xoffset[i]);
		}
		for(i=0;i<n;i++) alpha[i][k] = (t_vf[i]-t_va[i])/(x2[k]-x[k]);
	}

	for(i=0;i<n;i++) beta[i]=t_va[i];
}
