/*
From bink@athena.mit.edu Wed Apr 10 16:05:07 1991
Received: from ATHENA.MIT.EDU by poincare.geom.umn.edu; Wed, 10 Apr 91 16:04:59 CDT
Received: from M4-167-10.MIT.EDU by ATHENA.MIT.EDU with SMTP
        id AA09847; Wed, 10 Apr 91 17:04:52 EDT
From: bink@athena.mit.edu
Received: by m4-167-10.MIT.EDU (5.61/4.7) id AA24288; Wed, 10 Apr 91 17:04:36 -0400
Message-Id: <9104102104.AA24288@m4-167-10.MIT.EDU>
To: brakke@poincare
Subject: xgraph.c
Date: Wed, 10 Apr 91 17:04:31 EDT
Status: R

Here is the X windows interface I mentioned.  Just a few comments about it;
the author, Tim Shepard, a graduate student in the MIT Laboratory for Computer
Science, says, "It is a two hour hack, and not the best possible job."  My
own remarks are that xgraph_edge is untested to date, because I have yet to 
use that feature.  Also, despite the author's complaints about the ugliness
of the code, it has worked very nicely for everything I've needed thus far.
Besides the following, three lines need to be added to the Makefile.  They 
are:  CFLAGS= -DGENERIC
      GRAPH= xgraph.o
      GRAPHLIB= -lX11

                                                Livia Racz
                                                (racz@zither.mit.edu)
*/

/*************************************************************
*  This file is for the Surface Evolver source code.         *
*  by Tim Shepard for Livia Racz (March 1991)                *
*************************************************************/

/* (based on tcgraph.c) */

/* X11 graphics module */
/* All coordinates in absolute pixels in window */

#include "include.h"
#include <X11/Xlib.h>

static Display *dpy;
static Screen *screen;
static Window rootwin;
static Window win;
static XGCValues gcv;
static GC gc;
static XEvent event;
Colormap cmap;

static int maxx,maxy;  /* max viewport coordinates */
static double xscale,yscale;  /* for scaling to screen size */

static float light[3] = { 0.0, -1.0, 0.0 };

unsigned long grey_pixel_values[16];
unsigned long edge_pixel_value;


void init_xgraph()
{

  int waiting_for_window = 0;

  if ( init_flag == 0 ) {
      waiting_for_window = 1;
      init_flag = 1;

      dpy = XOpenDisplay("");
      if (dpy == NULL)
        error("Unable to open X display", RECOVERABLE);
      screen = XDefaultScreenOfDisplay(dpy);
      if (screen == NULL)
        error("Unable to get default screen of X display", RECOVERABLE);
      rootwin = XRootWindowOfScreen(screen);
      if (rootwin == NULL)
        error("Unable to get root window of screen", RECOVERABLE);
      win = XCreateSimpleWindow(dpy, rootwin, 0, 0, 500, 500, 1,
                          WhitePixelOfScreen(screen),
                          BlackPixelOfScreen(screen));
      if (win == NULL)
        error("Unable to create window", RECOVERABLE);

      cmap = DefaultColormap(dpy,/*XScreenNumberOfScreen(screen)*/0);


      XSelectInput(dpy, win, StructureNotifyMask);

      XMapRaised(dpy, win);

      gcv.foreground = WhitePixelOfScreen(screen);
      gcv.foreground = WhitePixelOfScreen(screen);
      gcv.background = BlackPixelOfScreen(screen);
      gcv.line_width = 0;

      gc = XCreateGC(dpy, win, GCForeground|GCLineWidth, &gcv);

      {
        int i;
        XColor xc;

/* edge color set here */
        xc.red = 0;
        xc.green = 0xffff;
        xc.blue = 0;
        xc.flags = DoRed|DoGreen|DoBlue;
        if (XAllocColor(dpy, cmap, &xc) == 0) {
          error("failed to allocate color", WARNING);
          xc.pixel = WhitePixelOfScreen(screen);
        }
        edge_pixel_value = xc.pixel;
        
/* 16 facet colors set here; these are gray levels */
        for (i=0;i<16;i++) {
          xc.red = xc.green = xc.blue = (i<<12)|(i<<8)|(i<<4)|i;
          if (xc.blue < 0x4444) {
            xc.blue = 0x4444;
          }
          xc.flags = DoRed|DoGreen|DoBlue;
          if (XAllocColor(dpy, cmap, &xc) == 0) {
            error("failed to allocated color", WARNING);
            xc.pixel =
              i>=8?WhitePixelOfScreen(screen): BlackPixelOfScreen(screen);
          }
          grey_pixel_values[i] = xc.pixel;
        }
      }
    }
  
  /*  Note: X events are only handled each time we get here.   This is not
      the best situation, but without trying to modify the command parser
      this is about the best we can do.
      */

  /* do this each time incase window has changed size */
  while (waiting_for_window || XPending(dpy) > 0) {
    XNextEvent(dpy, &event);
    switch(event.type) {
    case ConfigureNotify:
      maxx = event.xconfigure.width;
      maxy = event.xconfigure.height;
      xscale = (maxx<maxy?maxx:maxy)/3;
      yscale = xscale;
      waiting_for_window = 0;
      break;
    default:
      break;
    }
  }

  /* clear window */
  XClearWindow(dpy,win);
}

void xgraph_edge(t)
struct tsort *t;
{
  XPoint p[MAXCOORD];
  int i;

  for ( i = 0 ; i < 2 ; i++ )
    {
      p[i].x = (int)(t->x[i][0]*xscale) + maxx/2;
      p[i].y = maxy/2 - (int)(t->x[i][1]*yscale);
    }       

  if (gcv.foreground != WhitePixelOfScreen(screen)) {
    gcv.foreground = WhitePixelOfScreen(screen);
    XChangeGC(dpy, gc, GCForeground, &gcv);
  }
  XDrawLine(dpy, win, gc, p[0].x, p[0].y, p[1].x, p[1].y);
}

void xgraph_facet(t)
struct tsort *t;
{
  int n = FACET_VERTS;      /* vertices in polygon */
  XPoint p[6];              /* vertex coords       */
  int i,j,color;

  if ( (web.modeltype == QUADRATIC) && valid_id(t->f_id) )
    {
      double a[MAXCOORD+1],b[MAXCOORD+1],*y;
      facetedge_id fe;

      a[MAXCOORD] = 1.0;

      n = FACET_CTRL;
      fe = get_facet_fe(t->f_id);
      for ( i = 0 ; i < FACET_CTRL ; i += 2 )
        { 
          y = get_coord(get_fe_tailv(fe));
          for ( j = 0 ; j < MAXCOORD ; j++ ) a[j] = y[j];
          matvec_mul(view,a,b,MAXCOORD+1,MAXCOORD+1);  /* transform */
          p[i].x = (int)(b[1]*xscale) + maxx/2;
          p[i].y = maxy/2 - (int)(b[2]*yscale);
 
          y = get_coord(get_fe_midv(fe));
          for ( j = 0 ; j < MAXCOORD ; j++ ) a[j] = y[j];
          matvec_mul(view,a,b,MAXCOORD+1,MAXCOORD+1);  /* transform */
          p[i+1].x = (int)(b[1]*xscale) + maxx/2;
          p[i+1].y = maxy/2 - (int)(b[2]*yscale);

          fe = get_next_edge(fe);
        }
    }
  else
    for ( i = 0 ; i < MAXCOORD ; i++ )
     {
       p[i].x = (int)(t->x[i][0]*xscale) + maxx/2;
       p[i].y = maxy/2 - (int)(t->x[i][1]*yscale);
     }

  if ( web.hide_flag )  
    {
/*
      color = 15*(1 - dotf(t->normal,light,MAXCOORD)/
                  sqrt(dotf(t->normal,t->normal,MAXCOORD)))/2;
*/
      color = get_facet_color(t->f_id);
      if (gcv.foreground != grey_pixel_values[color]) {
        gcv.foreground = grey_pixel_values[color];
        XChangeGC(dpy, gc, GCForeground, &gcv);
      }
      XFillPolygon(dpy, win, gc, p, n, Complex, CoordModeOrigin);
    }

  if (gcv.foreground != edge_pixel_value) {
    gcv.foreground = edge_pixel_value;
    XChangeGC(dpy, gc, GCForeground, &gcv);
  }
  
  /******** could make all this faster by not using two calls so that things
    can be coalesced together in Xlib (and somehow prevent the intervening
    XChangeGC's)
    */
  XDrawLines(dpy, win, gc, p, n, CoordModeOrigin);
  XDrawLine(dpy, win, gc, p[n-1].x, p[n-1].y, p[0].x, p[0].y);/*finish it off*/
}

void finish_xgraph()
{
  XFlush(dpy);
}


void display()
{
  init_graphics = init_xgraph;
  finish_graphics = finish_xgraph;
  if ( web.dimension == STRING )
    {
      graph_start = init_graphics;
      graph_edge  = painter_edge;
      display_edge = xgraph_edge;
      graph_end   = null_function;
    }
  else
    { 
      graph_start = painter_start;
      graph_facet = painter_facet;
      display_facet = xgraph_facet;
      graph_end = painter_end;
    }
  
  graphgen();
}



