/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  Hcadvar.h: Header file for global variable.                  */
/*                                                               */
/*                                                               */
/*****************************************************************/

/*** Global variable for window ***/

char winame[ ]   = {
	"Hcad3D"};
char iconame[ ]  = {
	"cad"};
char atom_name[ ]  = {
	"_HYPERCAD"};
Display         *disp;        /* display */


Window          basewin;      /* base window */
Window          drawin;       /* window for drawing   */
Window          butt[7];      /* button window */
Window          menubar;      /* menu bar window*/
Window          menuwin;      /* menu window */
Window          sub_menuwin;  /* sub menu window */

GC              dragc;        /* graphics context for drawing window */
GC              menubargc;    /* graphics context for menu bar window */
GC              menugc;       /* graphics context for menu window */
GC              sub_menugc;   /* graphics context for sub menu window */
GC              norm_gc;      /* GC - Foreground black,Background white */
GC              invert_gc;    /* GC - Foreground white,Background black */


XSizeHints      basehint;     /* base window size */
XSizeHints      drahint;      /* drawing window size */
XSizeHints      menubarhint;  /* menu bar window size */
XSizeHints      menuhint;     /* menu window size */
XSizeHints      sub_menuhint; /* sub menu window size */

XEvent          ev;           /* event */

Pixmap          curmap[8];    /* Pixmap for cursor */
Pixmap          gray[10];     /* Pixmap for gray */

Font            font;
int             font_flg = FALSE;
int             done;         /* flag for main loop */
HPlane          plane[PLANE_MAX];  /* Hyperbolic planes */
HLine           line1[LINE_MAX];   /* Edges */
HPlane          unit_ball;    /* Unit ball */
Cursor          cur[8];       /* Cursor */
KeySym          mykey;        /* Key symbol */
int             hypscreen;    /* screen */

unsigned long   white;        /* White Color */
unsigned long   black;        /* Black Color */
static char     dash[]={
	1,5};    /* dash pattern of X */

/*** Global variable for drawing */
int             total_plane = 0;         /* total plane number */
int             total_line = 0;          /* total line number */
HPoint          coord[3] = { 
	{
		1.0, 0.0, 0.0	}
	,    /* vector for coordinate */
	{ 
		0.0,1.0, 0.0	}
	,
	{ 
		0.0, 0.0,1.0	} 
};         
int             indata_style = 1;        /* data input style */

int             disp_coord_flg = TRUE;   /* flag for displaying coordinate */
int             pr_coord_flg = FALSE;    /* flag for printing coordinate */
int             disp_unit_flg = TRUE;    /* flag for displaying unit ball */
int             pr_unit_flg = TRUE;      /* flag for printing unit ball */
int             draw_pattern = 1;        /* flag for drawing pattern */
int             print_pattern = 2;       /* flag for printing pattern */
int             shadow_flg = OFF;        /* flag for shadow */
int             pr_shadow_flg = OFF;     /* flag for printing shadow */
int             pr_header     = TRUE;    /* flag for printing header */
double          rotation_angle = 10.0;   /* angle of rotation */
double          magnification = 1.0;     /* magnification */
double          cosin[12],sine[12];      /* array of cos sin */
HPoint          view_vect = {
	0.0,0.0,1.0};  /* direction of view */
int             select_plane = -1;       /* selecting plane */
int             select_flg   = OFF;      /* flag for selecting plane */
int             select_line = -1;        /* selecting line */
int             select_l_flg = OFF;      /* flag for selecting line */


/* Global variable for file */
char            file_name[NAME_MAX];           /* editing file name */
char            ps_file[NAME_MAX];             /* postscript file name*/
char            file_path[NAME_MAX];           /* path of edit file */
char            work_path[NAME_MAX];           /* path of work file */
char            print_com[NAME_MAX];           /* command of printing */
char            demo_path[NAME_MAX];           /* path of demo file */

/* menu name */
char     *menu_name[MENU_MAX] = 
{
	"File",  
	"Data",
	"Print",
	"Select",
	"Help",
	"Demo",
	"Other",
	"Setting"};

char     *submenu_name[MENU_MAX][SUBMENU_MAX] = 
{ 
	{
		"present situation",
		"open",
		"save",
		"file directory",
		"work directory",
		"-------- ",
		"Quit"	}
	,
	{
		"show",
		"add",
		"change",
		"remove",
		"clear all",
		"data style",
		"-------- "	}
	,
	{
		"print",
		"make PS file",
		"set print command",
		"setting",
		"--------",
		"--------",
		"--------"	}
	,
	{
		"Select plane",
		"Select line",
		"--------",
		"--------",
		"--------",
		"--------",
		"--------"	}
	,
	{
		"File menu",
		"Data menu",
		"Print menu",
		"Select menu",
		"Demo menu",
		"Other menu",
		"Rotation"	}
	,
	{
		"tetrahedron",
		"octahedron",
		"truncated tetrahedron",
		"dodecahedron",
		"icosahedron",
		"hexahedron",
		"--------"	}
	,
	{
		"--------",
		"--------",
		"--------",
		"--------",
		"--------",
		"--------",
		"--------"	}
	,
	{
		"presentation",
		"rotation angle",
		"magnification",
		"redraw",
		"--------",
		"--------",
		"--------"	}
};

