/*ScianFiles.h
  External stuff for ScianFiles.c
  Eric Pepke
  August 17, 1990
*/

#define ALLOCTEXTBUF	200		/*Alloc chunk for text*/
/*Text buf type for keeping text*/
typedef struct
    {
	long builtTextLength;		/*Length of the built text*/
	long lastChar;			/*Index of the last char (NULL) in the text*/
	char *builtText;		/*The text itself*/
    } TextBuf;

extern ObjPtr fileClass;
extern ObjPtr allFileReaders;		/*List of all file readers*/
extern char *curFileName;

/*Is file predicate*/
#define IsFile(object) IntVarEql(object, CLASSID, CLASS_FILE)

#ifdef PROTO
void InitFiles(void);
void KillFiles(void);
void DefineFormat(char *, char *, ObjPtr (*reader)(), Bool (*writer)());
void ReadFile(char *, char *);
int FormatInfo(int, char *, char *);
ObjPtr NewFileReader(char *name);
ObjPtr ReadFormattedFile(ObjPtr, char *name);
ObjPtr FindFormatReader(char *format);
ObjPtr FindExtensionReader(char *ext);
WinInfoPtr FileReadersWindow(void);
void ReadObjectControls(ObjPtr, ObjPtr);
void SaveObjectControls(ObjPtr, ObjPtr);
void DoSaveObject(void);
void FileFormatError(char *, char *);
#else
void InitFiles();
void KillFiles();
void DefineFormat();
void ReadFile();
ObjPtr NewFileReader();
ObjPtr ReadFormattedFile();
ObjPtr FindFormatReader();
ObjPtr FindExtensionReader();
WinInfoPtr FileReadersWindow();
ObjPtr MakeDatasetName();
void ReadObjectControls();
void SaveObjectControls();
void DoSaveObject();
void FileFormatError();
#endif
