/*ScianControls.h
  External stuff for controls
  Eric Pepke
  March 28, 1990
*/

#define ICONXSPACE	100		/*X spacing between icons*/
#define ICONYSPACE	80		/*Y spacing between icons*/
#define ICONLEFTBORDER	50		/*Minimum x for icons*/
#define ICONBOTBORDER	70		/*Bottom border for icons*/
#define ICONTOPBORDER	30		/*Top border for icons*/
#define ICONRIGHTBORDER 50		/*Right border for icons*/
#define ICONXMINSPACE	70		/*Minimum X spacing*/
#define ICONYMINSPACE	70		/*Minimum Y spacing*/

#define BARRIGHT	1		/*Scroll bar on the right*/
#define BARBOTTOM	2		/*Scroll bar on bottom*/
#define BARLEFT		4		/*Scroll bar on the left*/
#define BARTOP		8		/*Scroll bar on the top*/
#define OBJECTSFROMTOP	16		/*Objects are dropped from top*/

extern ObjPtr screenClass, controlClass, corralClass, panelClass, greyPanelClass;

extern ObjPtr tempRepObj;		/*Temporary icon*/

#define IsSelected(o) (GetPredicate((o), REPOBJONLY) ? GetPredicate(GetVar((o), REPOBJ), SELECTED) : GetPredicate((o), SELECTED))

/*Is Corral predicate*/
#define IsCorral(object) IntVarEql(object, CLASSID, CLASS_CORRAL)

/*Is panel predicate*/
#define IsPanel(object) IntVarEql(object, CLASSID, CLASS_PANEL)

#ifdef PROTO
void InitControls(void);
ObjPtr NewPanel(ObjPtr, int, int, int, int);
ObjPtr NewIconCorral(ObjPtr, int, int, int, int, int);
void DropIconSeriesInCorral(ObjPtr, ObjPtr);
void DropIconInCorral(ObjPtr, ObjPtr);
ObjPtr NewSwitch(int, int, int, int, int, int, int, char *);
ObjPtr DrawField(ObjPtr);
void StartPanel(int, int, int, int);
real ChooseGoodStep(real min, real max);
void ChooseGoodSliderParams(real *min, real *max, real *bigStep, real *littleStep, real *anchor);
ObjPtr NewGreyCover(int, int, int, int);
ObjPtr NewControlField(int, int, int, int, char *name, int);
void ScrollHome(ObjPtr);
void SelectAllIcons(ObjPtr);
void DeselectAll();
void DoSelectAllIcons(void);
Bool Select(ObjPtr, Bool);
void ForAllSelectedObjects(FuncTyp);
Bool ParseReal(real *value, char *s);
Bool ParseInteger(int *value, char *s);
void PrintNumber(char *s, real value);
ObjPtr NewFlowLine(int, int, int, int, char *);
void SetSelection(ObjPtr, ObjPtr);
void ChangedSelection(ObjPtr);
#else
void InitControls();
ObjPtr NewPanel();
ObjPtr NewIconCorral();
void DropIconInCorral();
void DropIconSeriesInCorral();
ObjPtr NewSwitch();
ObjPtr DrawField();
void StartPanel();
real ChooseGoodStep();
void ChooseGoodSliderParams();
ObjPtr NewGreyCover();
ObjPtr NewControlField();
void ScrollHome();
void SelectAllIcons();
void DeselectAll();
void DoSelectAllIcons();
Bool Select();
void ForAllSelectedObjects();
Bool ParseReal();
Bool ParseInteger();
void PrintNumber();
ObjPtr NewFlowLine();
void SetSelection();
void ChangedSelection();
#endif

