/*ScianStyle.h
  Eric Pepke
  25 March 1991
  Numbers for common SciAn style
*/

#define MAJORBORDER	20		/*Major border around and within windows*/
#define MINORBORDER	10		/*Minor border within windows*/
#define CORRALBORDER	10		/*Border between an icon corral and window*/
#define SLIDERWIDTH	40		/*Width of a slider here*/
#define NARROWSLIDERWIDTH 30		/*Narrow slider*/
#define CHECKBOXHEIGHT	22		/*Height of a check box*/
#define CHECKBOXSPACING	5		/*Vertical spacing between boxes*/
#define TITLEBOXSPACING 6		/*Spacing between title boxes*/
#define TITLEBOXTOP	10		/*Top of a title box*/
#define BBCHECKBOXWIDTH	140		/*Width of a check box in BB controls*/
#define TEXTBOXHEIGHT	18		/*Height of a text box*/
#define EDITBOXHEIGHT	26		/*Height of an editable text box (1 line)*/
#define EDITBOXDOWN	(-3)		/*Amount text in an edit box is down*/
#define TEXTBOXSEP	6		/*Separation between a text box and object*/
#define COLORWHEELWIDTH	80		/*Width of an HS control*/
#define SWITCHWIDTH	70		/*Width of a switch*/
#define SSWITCHWIDTH	30		/*Width of a single switch*/
#define XYCONTROLWIDTH	90		/*Width of an XY control*/
#define ICONXYSEP	20		/*Separation of an icon from XY control*/
#define VWINHEIGHT	400		/*Height of a vis window*/
#define VWINPANELWIDTH	252		/*Width of a vis window panel*/
#define VWTOOLBORDER	4
#define VWINTOOLPWIDTH	(2 * VWTOOLBORDER + SMALLICONBUTTONSIZE)
#define VWINWIDTH	(VWINHEIGHT + VWINPANELWIDTH + VWINTOOLPWIDTH + 2)
#define VWTOOLBORDER	4
					/*Width of a vis window*/
					/*Width of a vis window tool panel*/
#define BARWIDTH	20		/*Width of a scroll bar*/
#define SLOP		30l		/*Slop around a, well anything*/
#define CORRALBARBORDER	4		/*Border on a scrollbar in a corral*/

#define TRACKEDGE	3		/*Edge around a track*/

#define PCWIDTH		90		/*Nominal width of a perspective control*/
#define CLWINWIDTH	450		/*Width of a clock window*/
#define CLWINHEIGHT	(3 * MAJORBORDER + CLTCHEIGHT + TITLEBOXTOP + 4 * MINORBORDER + EDITBOXHEIGHT + 3 * CHECKBOXHEIGHT + 2 * CHECKBOXSPACING + ICONBUTTONSIZE) 
					/*Height of a clock window*/
#define CLTCHEIGHT	200		/*Height of a time control in clock window*/
#define DSWINWIDTH	(360)		/*Width of a datasets window*/
#define DSWINHEIGHT	400		/*Height of a datasets window*/
#define MODWINWIDTH	DSWINWIDTH	/*Width of a modify window*/
#define MODWINHEIGHT	DSWINHEIGHT	/*Height of a modify window*/
#define FRWINWIDTH	350		/*Width of a file reader window*/
#define FRWINHEIGHT	360		/*Height of a file reader window*/
#define VAWINWIDTH	350		/*Visualize As Window Width*/
#define VAWINHEIGHT	350		/*Visualize As Window Height*/
#define OBFPCHEIGHT	170		/*Height of flights and perspective controls*/
#define OBXYWIDTH	OBFPCHEIGHT
#define OBWINWIDTH	(2 * MINORBORDER + SCALESLOP +			\
			 2 * MINORBORDER +				\
			 PCWIDTH +					\
			 OBXYWIDTH +					\
			 SLIDERWIDTH)	/*Width of an observer window*/
#define OBBOTTOMHEIGHT	(2 * MINORBORDER + TITLEBOXTOP + 2 * CHECKBOXHEIGHT + CHECKBOXSPACING + MINORBORDER + EDITBOXHEIGHT)
#define OBMIDHEIGHT	(OBFPCHEIGHT + TEXTBOXHEIGHT)
#define OBTOPHEIGHT	(TITLEBOXTOP + 3 * MINORBORDER + 2 * CHECKBOXHEIGHT)
#define OBWINHEIGHT	(OBBOTTOMHEIGHT + MINORBORDER + OBMIDHEIGHT + MINORBORDER + OBTOPHEIGHT + MINORBORDER * 2)
#define ICONBUTTONSIZE	50		/*Size of icon buttons*/
#define SMALLICONBUTTONSIZE	46	/*Size of a small icon button*/
#define ICONBUTTONSPACE	10		/*Spacing between icon buttons*/

#define ONECORRALWIDTH	108		/*Width of a corral for one object*/
#define ONECORRALHEIGHT	90		/*Height of a corral for one object*/

#define CWINWIDTH	570		/*Width of a control window*/
#define CWINHEIGHT	340		/*Height of a control window*/
#define CWINCORRALWIDTH	122		/*Width of a corral in a CWIN*/
#define CWINCCWIDTH	(CWINCORRALWIDTH - BARWIDTH - 10)
					/*Width of contents of corral*/
#define CWINICONBUTHEIGHT 62

#define FCWINWIDTH	(CWINWIDTH - CWINCORRALWIDTH - MINORBORDER)
					/*Width of a filter control window*/
#define FCWINHEIGHT	(CWINHEIGHT)

#define DCWINWIDTH	450		/*Width of a dataset controls window*/
#define DCWINHEIGHT	360		/*Height of a dataset controls window*/
#define DCINFOHEIGHT	80		/*Height of the info string*/
#define DCFONT		 (demoP ? "Helvetica-Bold" : "Helvetica")
					/*Font for info*/
#define DCFONTSIZE	14		/*Size of text for info*/

/*Socket control window*/
#define SCWINWIDTH	450		/*Width of a socket control window*/
#define SCWINHEIGHT	400		/*Height of a socket control window*/
#define SCFONT		 (demoP ? "Helvetica-Bold" : "Helvetica")
					/*Font for info*/
#define SCFONTSIZE	14		/*Size of text for info*/
#define SCTEXTHEIGHT	70		/*Height of text box*/
#define SCGRAPHICWIDTH	150		/*Width of the graphic*/

/*Process control window*/
#define PXWINWIDTH	(360)		/*Width of a process control window*/
#define PXWINHEIGHT	400		/*Height of a process control window*/


/*Ortho Slicer dimensions*/
#define OSDIMWIDTH	150		/*Obselete for control window*/
#define OSWINWIDTH	(4 * MAJORBORDER + 2 * ONECORRALWIDTH + 3 * OSDIMWIDTH)
					/*Width of an ortho slicer window*/
#define OSWINHEIGHT	350		/*Height of an ortho slicer window*/
#define OSAXISWIDTH	120		/*Width of axis button group*/	

#define PCWINWIDTH	740		/*Width of a palette window*/
#define PCWINHEIGHT	506		/*Height of a palette control window*/
#define PCBARHEIGHT	350		/*Height of a color bar*/
#define PCBARUP		(EDITBOXHEIGHT + MINORBORDER)
#define PCWINLSIDE	(5 * MINORBORDER + COLORWHEELWIDTH + SLIDERWIDTH + 20)
#define PCTEXTBOXLEN	100		/*Length of a text box*/

/*JEL textbox parameters */
#define DEFFONT (demoP ? "Helvetica-Bold" : "Helvetica")
#define DEFALIGN LEFTALIGN
#define DEFTEXTSIZE 12
#define DEFLINESPACE 6
#define TEXTCURSORCOLOR UIBLUE
#define TEXTSELECTCOLOR	UIWHITE
#define TEXTMARGIN	6

/*JEL alert window parameters */
#define ASKWIDTH	440
#define ASKHEIGHT	230
#define ALERTWIDTH	480
#define ALERTHEIGHT	260
#define ALERTBORDER	20
#define TOPMARGIN	(30 + ALERTBORDER)
#define SIDEMARGIN	(40 + ALERTBORDER)
#define BOTMARGIN	(30 + ALERTBORDER)
#define EDGE 3				/* edge size in everything */
#define PITBOXHEIGHT	(TEXTBOXHEIGHT + TEXTMARGIN * 2)

#define UIALERTBG UIBACKGROUND

#define PROMPTTEXTFONT	"Helvetica-Bold"
#define PROMPTTEXTSIZE	14
#define PROMPTTEXTCOLOR	UITEXT
#define PROMPTHT	4*(PROMPTTEXTSIZE + DEFLINESPACE)

#define EDTEXTHT	28


#define GAP		12
#define SMALLGAP	8
#define INTERSPACE	24

#define OKBTNWID	70
#define BUTTONHEIGHT	30		/*Default height for a button*/
#define OKBTNHT		BUTTONHEIGHT

#define CMDBUTTONWIDTH  90		/*Default width of a command button*/

#define SCALESLOP	28		/*Slop for scale of a slider*/

#define LWINWIDTH	220		/*Width of a lights window*/
#define LWINHEIGHT	140		/*Height of a lights window*/

#define RWINWIDTH	300		/*Width of a renderer window*/
#define RWINHEIGHT	250		/*Height of a renderer window*/

extern real xGrid, yGrid, xMid, yMid;
#define NGRIDSTEPS	25
#define GRIDX(f)   (((long)((((f - xMid + xGrid * 4 * NGRIDSTEPS) + xGrid / 2)) / (xGrid))) * xGrid + xMid - xGrid * 4 * NGRIDSTEPS)
#define GRIDY(f)   (((long)((((f - yMid + yGrid * 4 * NGRIDSTEPS) + yGrid / 2)) / (yGrid))) * yGrid + yMid - yGrid * 4 * NGRIDSTEPS)
#define DGX(f)   (((long)((((f + xGrid * 4 * NGRIDSTEPS) + xGrid / 2)) / (xGrid))) * xGrid - xGrid * 4 * NGRIDSTEPS)
#define DGY(f)   (((long)((((f + yGrid * 4 * NGRIDSTEPS) + yGrid / 2)) / (yGrid))) * yGrid - yGrid * 4 * NGRIDSTEPS)

#define GRIDSIZE	16
#define GRIDDED(f)   (((long)(((f + GRIDSIZE / 2)) / (GRIDSIZE))) * GRIDSIZE)

/*Annotation defines*/
#define ANNOTHEIGHT	48		/*Height of an annotation*/
#define ANNOTWIDTH	192		/*Width of an annotation*/
#define ANNOTFONT	"Helvetica-Bold"/*Default font of an annotation*/
#define ANNOTFONTSIZE	18		/*Default font size of an annotation*/
#define ANNOTMINX	GRIDSIZE * 4	/*Min x of annotation*/
#define ANNOTMAXY	GRIDSIZE * 4	/*Max y of annotation*/
#define ANNOTSTAGGER	GRIDSIZE * 2	/*Stagger*/
#define ANNOTMAXSTAGGER GRIDSIZE * 16	/*Maximum stagger*/

/*** Text box defines ***/
#define PLAIN		0
#define TEXTBOXCOLOR	UIPINK


/* parameters for incredibly fancy frame for moving and resizing text boxes */
#define HANDLESIZE		12
#define INSIDEFRAMEWEIGHT	4
#define OUTSIDEFRAMEWEIGHT	2
#define INSET ((HANDLESIZE - (2*OUTSIDEFRAMEWEIGHT + INSIDEFRAMEWEIGHT))/2)
#define	OUTSIDEFRAMECOLOR	UIWHITE
#define	INSIDEFRAMECOLOR	UIBLACK

/*Time control defines*/
#define TCDSWIDTH	100		/*Width of the dataset portion*/
#define TCGAP		4		/*Gap between portions*/
#define TCCURHEIGHT	25		/*Height of current time area*/
#define TCCURWIDTH	14		/*Width of current time button*/
#define TCTIMEHEIGHT	25		/*Height of time area*/
#define TCFONT		 (demoP ? "Helvetica-Bold" : "Helvetica")
					/*Font to use in time control*/
#define TCFONTSIZE	12		/*Size of time control font*/
#define TCTEXTBOFF	4		/*Bottom offset for text*/
#define TCTEXTLOFF	5		/*Left offset for text*/
#define TCCELLHEIGHT	20		/*Height of a cell*/
#define TCLINEBOFF	9		/*Offset from bottom to line*/
#define TCSTEPPIXELS	30		/*Desired number of pixels in a time step*/
#define TCSAMPLESIZE	10		/*Size of a sample circle*/
#define TCSAMPLECOLOR	UIBLUE		/*Color of a time sample*/
#define TCTIMEPIXELS	60		/*Number of pixels betweeen times*/
#define TCTIMEFONT	 (demoP ? "Helvetica-Bold" : "Helvetica")
					/*Font in which to display time*/
#define TCTIMEFONTSIZE	12		/*Size in which to display time*/
#define TCTIMEBOFF	9		/*Bottom offset to up time display*/
#define TCMAXTIMEWIDTH	100		/*Maximum number of pixels for time*/
#define TCSCROLLBORDER	50		/*Border around time control for scroll*/
#define TCMIDTICHEIGHT	5		/*Height of the middle tic*/

/*Help window defines*/
#define HWWIDTH		700		/*Width of help window*/
#define HWHEIGHT	400		/*Height of help window*/
#define HWRADIOWIDTH	150		/*Width of radio buttons in help window*/
#define HELPFONT	 (demoP ? "Helvetica-Bold" : "Helvetica")
					/*Font for help*/
#define HELPSIZE	14		/*Size of text for help*/
#define HELPTITLESIZE	18		/*Size of title for help*/

/*Contour control defines*/
#define CCBUTTONLENGTH	185		/*Length of a color cell button*/

/*Isosurface defines*/
#define ISOMISSLENGTH	160		/*Missing data*/			

#define SPACESPHERESIZE 0.45		/*Radius of a space rotation sphere*/

/*Button stuff*/
#define BUTTONFONT	 (demoP ? "Helvetica-Bold" : "Helvetica")
#define BUTTONFONTSIZE	12
#define BUTTONSMALLSIZE	10

#define ICONTEXTFONT	(demoP ? "Helvetica-Bold" : "Helvetica")

/*Stuff for translucent and transparent controls*/
#define TRANSPARENTWIDTH 150		/*Width of transparent control*/

/*Stuff for color bar control*/
#define CBLBORDER	15		/*Left border around color bar*/
#define CBLTEXTSPACE	25		/*Space for text on the left*/
#define CBRBORDER	15		/*Right border around color bar*/
#define CBBORDER	12		/*Bottom border*/
#define CBTBORDER	15		/*Top border*/
#define CBHGAP		10		/*Horizontal gap between bits of color bar*/
#define CBVGAP		10		/*Vertical gap between bits of color bar*/
#define CBBOXWIDTH	40		/*Width of a box*/
#define CBCOMPHEIGHT	33		/*Height of a component*/
#define CBTEXTSEP	20		/*Text separation*/
#define CBTEXTFONT	(demoP ? "Helvetica-Bold" : "Helvetica")
#define CBTEXTSIZE	10
#define CBMAJORTICLEN	8		/*Length of major tics*/
#define CBSTEPPIXELS	50		/*Desired number of pixels in a step*/
#define CBTEXTUP	2		/*Pixels up to move text*/
#define CBBIGTEXTFONT	(demoP ? "Helvetica-Bold" : "Helvetica")
#define CBBIGTEXTSIZE	12
#define CBCOMPTEXTDOWN	3
#define CBTEXTDOWN	10		/*Text down from top*/
#define CBTEXTDOWNSEP	15		/*Separation of downward text*/
#define CBHANDLESIZE	6		/*Size of a handle*/

/*Stuff for contour control*/
#define CCLBORDER	20		/*Left border around contour control*/
#define CCRBORDER	20		/*Right border around contour control*/
#define CCTEXTFONT	(demoP ? "Helvetica-Bold" : "Helvetica")
#define CCTEXTSIZE	10
#define CCBORDER	12		/*Bottom border*/
#define CCTBORDER	10		/*Top border*/
#define CCTEXTUP	2		/*Pixels up to move text*/
#define CCSTEPPIXELS	50		/*Desired number of pixels in a step*/
#define CCBBORDER	10		/*Bottom border*/
#define CCTEXTSEP	20		/*Text separation*/
#define CCMAJORTICLEN	8		/*Length of major tics*/
#define CCMARKBUTLEN	15		/*Length of CC mark button*/
#define CCMARKBUTWIDTH	10		/*Width of CC mark button*/

/*Stuff for surface control panel*/
#define SCDRAWBOXLENGTH	150		/*Length of a draw checkbox*/

/*Stuff for sniff window*/
#define SNIFFWINHEIGHT	350
#define SNIFFSHOWWIDTH	80
#define SNIFFVALWIDTH	140
#define SNIFFTYPEWIDTH	100
#define SNIFFIDWIDTH	180
#define SNIFFWINWIDTH	(SNIFFIDWIDTH + SNIFFTYPEWIDTH + SNIFFVALWIDTH + SNIFFSHOWWIDTH \
			  + 7 * MINORBORDER + BARWIDTH + 5)

/*Stuff for arrows controls*/
#define ACNAMEWIDTH	140		/*Width of parameter name field*/
#define ACTEXTWIDTH	100		/*Width of text pit*/

/*Stuff for file reader control panel*/
#define FREXTTITLEWIDTH	150		/*Width of the string for default extension*/
#define FREXTTEXTWIDTH	100		/*Width of the text box for default extension*/
#define FRTIMEWIDTH	340		/*Width for time by name*/ 
#define FROVERALLWIDTH	340		/*Overall width*/

/*Stuff for HDF reader*/
#define HDFRADIOWIDTH	250		/*Width of radio buttons*/
#define HDFVECTORWIDTH	250		/*Width of vector check box*/

/*Stuff for bounds controls*/
#define SBFUNCTIONNAMEWIDTH	85	/*Width of function name*/
#define SBFUNCTIONSPACING	6	/*Spacing between functions*/

/*Stuff for pictures*/
#define PICSPHEREBOXWID	300		/*Width of a sphere box*/
#define PICFRUSTABOXWID	300		/*Width of a frustum box*/

/*Stuff for color palette displays*/
#define DSPPALETTEWIDTH	160		/*Width of a displayed palette*/
#define DSPPALETTEHEIGHT 250		/*Height of a displayed palette*/
#define DSPPALETTEFONT	"Helvetica-Bold"/*Default font of a displayed palette*/
#define DSPPALETTESIZE	14		/*Default font size of a displayed palette*/
#define DSPPALETTESTL	3		/*String to line margin*/

/*Stuff for color palette display window*/
#define DSPPALWINWIDTH	(2 * MAJORBORDER + 2 * (4 * MAJORBORDER + SLIDERWIDTH + COLORWHEELWIDTH) + MINORBORDER)
#define DSPPALWINHEIGHT	(2 * MAJORBORDER + (COLORWHEELWIDTH + TITLEBOXTOP + MAJORBORDER + 2 * MINORBORDER + TEXTBOXSEP + TEXTBOXHEIGHT + CHECKBOXHEIGHT) + 2 * (CHECKBOXHEIGHT + MINORBORDER))

/*Stuff for space panel control panel*/
#define SPWINWIDTH	(2 * MAJORBORDER + (3 * MAJORBORDER + SLIDERWIDTH + COLORWHEELWIDTH))
#define SPWINHEIGHT	(2 * MAJORBORDER + (COLORWHEELWIDTH + TEXTBOXSEP + TEXTBOXHEIGHT + 2 * CHECKBOXHEIGHT + TITLEBOXTOP + 4 * MINORBORDER))

/*Stuff for text box control panel window*/
#define TBPALWINWIDTH	(2 * MAJORBORDER + 2 * (4 * MAJORBORDER + SLIDERWIDTH + COLORWHEELWIDTH) + MINORBORDER)
#define TBPALWINHEIGHT	(2 * MAJORBORDER + (COLORWHEELWIDTH + TITLEBOXTOP + MAJORBORDER + 2 * MINORBORDER + TEXTBOXSEP + TEXTBOXHEIGHT + CHECKBOXHEIGHT))

/*Stuff for clock display control panel window*/
#define CDWINWIDTH	(2 * MINORBORDER + 2 * (2 * MINORBORDER + 2 * MAJORBORDER + SLIDERWIDTH + COLORWHEELWIDTH) + MINORBORDER)
#define CDWINHEIGHT	(2 * MINORBORDER + (COLORWHEELWIDTH + TITLEBOXTOP + MINORBORDER + 2 * MINORBORDER + TEXTBOXSEP + TEXTBOXHEIGHT + CHECKBOXHEIGHT) + MAJORBORDER + EDITBOXHEIGHT)
#define CDFORMATLABELWIDTH	70

/*Stuff for line control panel window*/
#define LCWINWIDTH	(2 * MINORBORDER + 2 * (4 * MINORBORDER + SLIDERWIDTH + COLORWHEELWIDTH) + MINORBORDER)
#define LCWINHEIGHT	(3 * MINORBORDER + (TITLEBOXTOP + 4 * CHECKBOXHEIGHT + 5 * CHECKBOXSPACING) + (COLORWHEELWIDTH + TITLEBOXTOP + MAJORBORDER + MINORBORDER + TEXTBOXSEP + TEXTBOXHEIGHT))

/*Stuff for rectangle control panel window*/
#define RCWINWIDTH	(2 * MINORBORDER + 2 * (4 * MINORBORDER + SLIDERWIDTH + COLORWHEELWIDTH) + MINORBORDER)
#define RCWINHEIGHT	(3 * MINORBORDER + (TITLEBOXTOP + 4 * CHECKBOXHEIGHT + 5 * CHECKBOXSPACING) + (COLORWHEELWIDTH + TITLEBOXTOP + MAJORBORDER + 2 * MINORBORDER + TEXTBOXSEP + TEXTBOXHEIGHT + CHECKBOXHEIGHT))

/*Stuff for deformation*/
#define DEFORMEDITWIDTH	80		/*Width of an edit box for deformation*/

#define UIINFOALERT	UIPMAGENTA	/* information alert color */
#define UICAUTIONALERT	UIPMAGENTA	/* caution alert color */
#define UIERRORALERT	UIYELLOW	/* error alert color */
#define UISEVEREALERT	UIRED		/* severe error alert color */
#define UIPGMERRALERT	UIORANGE	/* program error alert color */

#define LILBTNSIZ	24

#define BTNFONT		"Helvetica"
#define BTNFONTSIZE	12
#define BTNMARGIN	10	/* edge of button to label */

#define TRK_WID 10	/* width of slider track */
#define CTL_WID 12	/* width of slider control */

#define SCALEFONTSIZE 10	/* font size for slider scale */

#define BIGTICK 10	/* tick lengths for slider scale */
#define LILTICK 6

#define PLAIN		0
#define TEXTBOXCOLOR	UIPINK
#define TABWID	4	/* number of 'chars' per tab stop */

#define DUPOFFSET	16		/*X and Y pixel offset for duplication*/
