/*ScianObjWindow.h
  External stuff for obj windows.
  Eric Pepke
  March 28, 1990
*/

/*Bits for stickiness*/
#define STICKYRIGHT	1	/*Right side sticks to rel. posn. from right*/
#define STICKYLEFT	2	/*Left side sticks to rel. posn. from left*/
#define STICKYTOP	4	/*Top side sticks to rel. posn. from top*/
#define STICKYBOTTOM	8	/*Bottom side sticks to rel. posn. from bottom*/
#define FLOATINGRIGHT	16	/*Right side floats between right and left*/
#define FLOATINGLEFT	32
#define FLOATINGTOP	64
#define FLOATINGBOTTOM	128

extern ObjPtr objWindowClass;
extern ObjPtr dragBuffer;

#ifdef PROTO
WinInfoPtr NewObjWindow(ObjPtr, char *, long, int, int, int, int);
void DrawMe(ObjPtr);
void ImInvalid(ObjPtr);
void PauseDrawing(Bool);
void InitObjWindows(void);
void KillObjWindows(void);
void MakeMeCurrent(ObjPtr);
Bool AmICurrent(ObjPtr);
Bool NeedsSBDrawing(ObjPtr);
Bool NeedsDBDrawing(ObjPtr);
ObjPtr FindNamedObject(ObjPtr, char *);
void DoDelete(void);
Bool Get2DIntBounds(ObjPtr, int *, int *, int *, int *);
Bool Set2DIntBounds(ObjPtr, int, int, int, int);
ObjPtr FindPanelContents(WinInfoPtr);
ObjPtr PressObjWindows(WinInfoPtr, long);
#else
WinInfoPtr NewObjWindow();
void DrawMe();
void ImInvalid();
void PauseDrawing();
void InitObjWindows();
void KillObjWindows();
void MakeMeCurrent();
Bool AmICurrent();
Bool NeedsSBDrawing(ObjPtr);
Bool NeedsDBDrawing(ObjPtr);
ObjPtr FindNamedObject();
void DoDelete();
Bool Get2DIntBounds();
Bool Set2DIntBounds();
ObjPtr FindPanelContents();
#endif
