
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int err_msg()
/*
/* DESCRIPTION:
/*    Print error message to standard out.
/*
/* USAGE:
/*    error_ret = err_msg(mname,err_no);
/*
/* ARGUMENTS:
/*    char  *mname  (in) : module name (subroutine, function, or
/*                       : program name as a character string)
/*    int   err_no  (in) : error number returned by module
/*
/* RETURNS: (int)
/*    0 : no error occured (err_no = 0)
/*    1 : error occured (err_no != 0)
/*
/* COMMENTS:
/* EXAMPLE:
/*    err_ret = err_msg("main",3);
/*    The above statement would print the following to stdout:
/* ERROR   : main(err=3)
/*
/* SEE ALSO:
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : November 14, 1988
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

int err_msg(mname,err_no)
char *mname;
int err_no;
{
	int err_ret;
	if (!err_no){
		err_ret = 0;
		goto error;
		}

	printf("ERROR   : %s(err=%d)\n",mname,err_no);
	err_ret = 1;

error:	return(err_ret);

}
