	Program HDFTEST
C
C   Program for creating an image and storing it in an HDF file
C
C  If "row order" is selected the image created, with it's palette, 
C  should display as an increasingly dark gray scale going from top
C  to bottom, up to 256 rows, then repeating.  If "column order" is
C  chosen, this pattern will be transposed.
C
C  User supplies filename, height, width, compression, and whether
C  to store image in row or column order.
C
	Integer	      Row, Column
	Integer       Color
	Integer       Compress
	Integer       ReturnCode
	Integer       Index1, Index2, Index3
	Character*1   Image(307200)
	Character*1   Palette(768)
	Character*1   Order
	Character*64  FileName

	print *,'HDFTEST - Generate HDF Test File'

	print *
	print *,'Row Value: 1-480'
	print 210
210	Format(' Enter number of rows: ',$)
	read *, Row

	print *
	print *,'Column Value: 1-640'
	print 310
310	Format(' Enter number of columns: ',$)
	read *,Column

	print *
	print *,'Row/Column Order: R=Row, C=Column'
	print 410
410	Format(' Enter order: ',$)
        read (*,420) Order
420     format (a1)

	print *
	print *,'Compression Code: 0=None, 11=Run Length, 12=IMCOMP'
	print 510
510	Format(' Enter compression code: ',$)
	read *,Compress

	print *
	print *,'File Name: Up To 64 Characters'
	print 610
610	Format(' Enter file name: ',$)
        read (*, 620) Filename
620     format(a64)

	If (Order.eq.'C' .or. Order.eq.'c') then
	   Do 720 Index1=1,Row
	      Color=0
	      Do 710 Index2=1,Column
	         Image(((Index1*Column)-Column)+Index2)=CHAR(Color)
	         Color=Color+1
	         If (Color.gt.255) then
	            Color=0
	         End If
710       continue
720    continue 
	Else
	   Do 820 Index1=1,Column
	      Color=0
	      Do 810 Index2=1,Row
	         Image(((Index2*Column)-Column)+Index1)=CHAR(Color)
	         Color=Color+1
	         If (Color.gt.255) then
	            Color=0
	         End If
810       continue
820    continue
	End If

	Color=255
	Do 910 Index3=1,768,3
	   Palette(Index3+0)=CHAR(Color)
	   Palette(Index3+1)=CHAR(Color)
	   Palette(Index3+2)=CHAR(Color)
	   Color=Color-1
	   If (Color.lt.0) then
	      Color=255
	   End If
910	continue

	ReturnCode = d8spal(Palette)
	If (ReturnCode.ne.0) then
	   print *,'Error calling d8spal'
	End If

	ReturnCode=d8pimg(FileName,Image,Column,Row,Compress)
	If (ReturnCode.ne.0) then
	   print *,'Error calling d8pimg'
	End If

	print *
	print *,'HDFTEST - Finished'

	Stop

	End

