/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server menu driver code */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node115.text,v $ */

static char rcsid[] = "menu.c $Revision: 1.1 $ $Date: 92/05/08 15:25:41 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/MenuShell.h>
#include <Xm/PanedW.h>
#include <Xm/CascadeBG.h>
/* ------------------------------------------------------------------------ */
/* The standard widget slot is normally the cascade button with the menu,
 * except if there is no button, then it's the actual menu, and menu_widget
 * is NULL.
 */
typedef struct menu_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  t_sexp tag;
  t_sexp key;
  Widget menu_widget;
  Widget button_widget;
  Widget title_widget;
  Widget separator_widget;
  t_generic_widget items;		/* linked list of items */
  /* popup menu things */
  t_sexp context;
  char *header;
  char wrap;
} * t_menu_widget;

typedef struct menu_bar_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  t_generic_widget items;		/* linked list of items in menubar */
} * t_menu_bar_widget;
/* ------------------------------------------------------------------------ */
extern void
  MenuBarRemove(), MenuBarUpdate(), MenuBarChildRemoved(),
  MenuBarRealized(), MenuBarTransmit(), MenuBarEditable();

extern t_generic_widget MenuBarHandle();

struct widget_class_struct MenuBarClassRecord =
{
  WS_MENU_BAR, "menu-bar",
  MenuBarHandle, MenuBarRemove, MenuBarChildRemoved, MenuBarUpdate,
  GenericReply, MenuBarRealized, MenuBarTransmit, MenuBarEditable,
} ;

extern void
  MenuRemove(), MenuUpdate(), MenuChildRemoved(), MenuReply(),
  MenuRealized(), MenuTransmit(), MenuEditable();

extern t_generic_widget MenuHandle();

struct widget_class_struct MenuClassRecord =
{
  WS_MENU, "menu",
  MenuHandle, MenuRemove, MenuChildRemoved, MenuUpdate, MenuReply,
  MenuRealized, MenuTransmit, MenuEditable,
} ;
/* ------------------------------------------------------------------------ */
void
MenuBarRemove(self) t_menu_bar_widget self;
{
  RemoveWidgetList(self->items);
  MBfree(self->id);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
void
MenuBarChildRemoved(self, child)
     t_menu_bar_widget self;
     t_generic_widget child;
{
  /* I guess the only thing to do is remove the child from the list of
   * items in the menu */
  self->items = RemoveChildFromList(self->items, child);
}
/* ------------------------------------------------------------------------ */
/* not actually used at the moment */
void
MenuBarReply(self, reply)
     t_menu_bar_widget self;
     t_mbus_reply reply;
{
}
/* ------------------------------------------------------------------------ */
void
MenuBarUpdate(self,sexp)
     t_menu_bar_widget self;
     t_sexp sexp;
{
  UpdateWidgetList(self->items, sexp);
}
/* ------------------------------------------------------------------------ */
/* Transmit data to the MBus */
void
MenuBarTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_menu_bar_widget self;
{
  TransmitWidgetList(message, orig_reply, self->items);
}
/* ------------------------------------------------------------------------ */
void
MenuBarEditable(self,flag)
     t_menu_bar_widget self;
     int flag;
{
  EditableWidgetList(self->items, flag);
}
/* ------------------------------------------------------------------------ */
void
MenuBarRealized(self) t_menu_bar_widget self;
{
  t_generic_widget item;

  for ( item = self->items ; NULL != item ; item = item->next )
    item->class->realized(item);
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct mbkw[] =
{
  { ":special", NULL, KEYWORD_SEXP },
  { ":raised", (void *)KEYWORD_TRUE, KEYWORD_FLAG },
};

t_generic_widget
MenuBarHandle(parent, sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_menu_bar_widget menu;
  t_generic_widget current;
  t_sexp item;
  t_sexp special;
  int raised;
  int n;
  Arg argl[2];

  if (NULL == parent || NULL == sexp) return NULL;

  menu = NEW_STRUCT(menu_bar_widget_struct);
  menu->type = WS_MENU_BAR;
  menu->class = &MenuBarClassRecord;
  menu->parent = parent;
  menu->top = parent->top;
  menu->id = Getnth(sexp,1);
  menu->items = NULL;

  n = 0;
  MBparse_keywords(MBnthcdr(sexp, 3), mbkw, ARRAY_SIZE(mbkw));
  special = (t_sexp)mbkw[n++].result;
  raised = (t_keyword_flag)mbkw[n++].result == KEYWORD_TRUE;
  
  n = 0;
  XtSetArg(argl[n], XmNuserData, menu), ++n;
  
  if (!raised)
      XtSetArg(argl[n], XmNshadowThickness, 0), ++n;
  
  menu->widget = XmCreateMenuBar(parent->widget, "menubar", argl, n);

  /* handle the items of the menu bar */
  for ( item = MBnth(sexp,2) ; MB_CONSP(item) ; item = MB_CDR(item) )
    {
      current = HandleBusItem(menu, MB_CAR(item));

      if (NULL != current)
	{
	  current->next = menu->items;
	  menu->items = current;
	}
    }

  /* ought to check and verify that we got some items here... */

  /* See if we want to set one of the items to "special", i.e. the
   * help widget
   */
  if (NULL != special)
    {
      t_generic_widget w_item;
      for ( w_item = menu->items ; NULL != w_item ; w_item = w_item->next )
	if (MBequal(special, w_item->id))
	  {
	    XtSetArg(argl[0], XmNmenuHelpWidget, w_item->widget);
	    XtSetValues(menu->widget, argl, 1);
	    break;
	  }
    }


  ManageWidgetList(menu->items);

  return (t_generic_widget)menu;
}
/* ------------------------------------------------------------------------ */
void
MenuDeleteItem(menu, id)
     t_menu_widget menu;
     t_sexp id;
{
  t_generic_widget p;			/* previous item in the list */
  t_generic_widget c;			/* current item in the list */

  for ( p = NULL, c = menu->items ; NULL != c ; p = c, c = c->next )
    {
      if (MBequal(c->id, id))
	{
	  if (NULL == p) menu->items = c->next;
	  else p->next = c->next;
	  XtDestroyWidget(c->widget);
	  c->class->remove(c);		/* this frees c also(!) */
	  break;
	}
    }
}
/* ------------------------------------------------------------------------ */
t_generic_widget
MenuHandleItems(menu, sexp)
     t_menu_widget menu;
     t_sexp sexp;
{
  t_generic_widget result = NULL;
  t_generic_widget current;
  t_sexp item;
  Widget save;

  /* gotta force the widget pointer to the menu, for child widgets */
  save = menu->widget;
  menu->widget = menu->menu_widget;

  /* handle the items of the menu bar */
  for ( ; MB_CONSP(sexp) ; sexp = MB_CDR(sexp) )
    {
      item = MB_CAR(sexp);

      /* try to handle a singleton, instead of a list */
      if (!MB_CONSP(item)) item = sexp, sexp = NULL;

      if (NULL != (current = HandleBusItem(menu, item)))
	{
	  current->next = result;
	  result = current;
	}
    }

  menu->widget = save;
  return result;
}
  
/* ------------------------------------------------------------------------ */
/* These two functions must be split up so that the reply can get off before
 * the menu is removed.
 */
void
MenuPopupRemove(w, menu, data)
     Widget w;
     t_menu_widget menu;
     XmRowColumnCallbackStruct *data;
{
  MenuRemove(menu);
}
/* ------------------------------------------------------------------------ */
void
MenuPopupDestroy(w, menu, data)
     Widget w;
     t_menu_widget menu;
     XmRowColumnCallbackStruct *data;
{
  XtDestroyWidget(menu->menu_widget);
}
/* ------------------------------------------------------------------------ */
/* this is called if the menu is a popup, in which case several special
 * things must be done.
 */
void
MenuPopupFixup(menu) t_menu_widget menu;
{
  Window root, child;
  XButtonPressedEvent event;

  /* Position the menu at the mouse */
  XQueryPointer(XtDisplay(menu->menu_widget),
		RootWindowOfScreen(XtScreen(menu->menu_widget)),
		&root, &child,
		&event.x_root, &event.y_root, &event.x, &event.y,
		&event.state);
  XmMenuPosition(menu->menu_widget, &event);
  XtAddCallback(menu->menu_widget, XmNunmapCallback, MenuPopupDestroy, menu);
  XtAddCallback(menu->menu_widget, XmNdestroyCallback, MenuPopupRemove, menu);
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct MenuKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
  { ":label", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_GET_SEXP },
  { ":key", NULL, KEYWORD_GET_SEXP },
  { ":sensitive", (void *)KEYWORD_NONE, KEYWORD_FLAG },
  { ":context", NULL, KEYWORD_GET_SEXP },
  { ":header", NULL, KEYWORD_COOKED },
  { ":wrap", (void*)KEYWORD_TRUE, KEYWORD_FLAG },
  { ":values", NULL, KEYWORD_SEXP },
  { ":mnemonic", NULL, KEYWORD_COOKED },
};

t_generic_widget
MenuHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_menu_widget menu;
  char *title, *label, *str, *mnemonic;
  t_keyword_flag sensitive;
  t_sexp item;
  t_generic_widget current;
  int n;
  Arg argl[6];

  if (NULL == sexp) return NULL;

  menu = NEW_STRUCT(menu_widget_struct);
  menu->type = WS_MENU;
  menu->class = &MenuClassRecord;
  menu->items = NULL;
  menu->parent = parent;
  menu->top = (parent != NULL ? parent->top : (t_generic_widget)menu);
  menu->id = Getnth(sexp,1);
  menu->button_widget = NULL;

  /* sexp should be (menu "id" <items> &key ...) */
  MBparse_keywords(MBnthcdr(sexp,3), MenuKeywords, ARRAY_SIZE(MenuKeywords));
  n = 0;
  title = (char *)MenuKeywords[n++].result;
  label = (char *)MenuKeywords[n++].result;
  menu->tag = (t_sexp)MenuKeywords[n++].result;
  menu->key = (t_sexp)MenuKeywords[n++].result;
  sensitive = (t_keyword_flag)MenuKeywords[n++].result;
  menu->context = (t_sexp)MenuKeywords[n++].result;
  menu->header = (char *)MenuKeywords[n++].result;
  menu->wrap = KEYWORD_FALSE != (t_keyword_flag)MenuKeywords[n++].result;
  menu->values = ContextString((t_sexp)MenuKeywords[n++].result);
  mnemonic = (char *)MenuKeywords[n++].result;

  if (NULL != label) str = label;
  else if (NULL != title) str = title;
  else str = "Menu";

  n = 0;
  XtSetArg(argl[n], XmNuserData, menu), ++n;
  if (NULL == parent)
    {
      /*
      XtSetArg(argl[n], XmNmenuPost, "<Btn1>"), ++n;
      */
      menu->menu_widget = XmCreatePopupMenu(toplevel_widget, "menu", argl, n);
    }
  else
    {
      menu->menu_widget = XmCreatePulldownMenu(parent->widget,
					       "menu", argl, n);

      if (WS_MENU == parent->type || WS_MENU_BAR == parent->type)
	{
	  XmString xm_label = CtoXmString(label);

	  XtSetArg(argl[n], XmNlabelString, xm_label), ++n;
	  XtSetArg(argl[n], XmNsubMenuId, menu->menu_widget), ++n;
	  if (KEYWORD_NONE != sensitive)
	    XtSetArg(argl[n], XmNsensitive, KEYWORD_TRUE == sensitive), ++n;
	  if (NULL != mnemonic)
	    {
	      KeySym keysym = XStringToKeysym(mnemonic);
	      if (NoSymbol != keysym)
		XtSetArg(argl[n], XmNmnemonic, keysym), ++n;
	    }

	  menu->button_widget =
	    XtCreateManagedWidget("submenu", xmCascadeButtonGadgetClass,
				 parent->widget, argl, n);
	  XmStringFree(xm_label);
	}
    }

  menu->title_widget =
    CreateTitle(NULL == title ? "" : title, menu->menu_widget);
  menu->separator_widget = XtCreateWidget("separator", xmSeparatorGadgetClass,
					  menu->menu_widget, NULL, 0);
  if (NULL != title)
    {
      XtManageChild(menu->title_widget);
      XtManageChild(menu->separator_widget);
    }

  XtFree(title);
  XtFree(label);
  XtFree(mnemonic);

  menu->items = MenuHandleItems(menu, MBnth(sexp, 2));
  ManageWidgetList(menu->items);

  /* Ok. If we had to create a cascade button, we want our parent to manage
   * that, and not the menu itself.
   */
  menu->widget = NULL == menu->button_widget
    ? menu->menu_widget : menu->button_widget;

  if (NULL == parent) MenuPopupFixup(menu);

  return (t_generic_widget)menu;
}
/* ------------------------------------------------------------------------ */
/* Called by someone else when they want us to remove all of our data
 * structures. Destruction of the widgets is the caller's job.
 */
void
MenuRemove(self) t_menu_widget self;
{
  MBfree(self->id);
  MBfree(self->tag);
  MBfree(self->key);
  MBfree(self->context);
  XtFree(self->header);
  XtFree(self->values);
  RemoveWidgetList(self->items);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Called with an update sexp */
static struct keyword_entry_struct mukw [] =
{
  { ":title", NULL, KEYWORD_SEXP },
  { ":add", NULL, KEYWORD_SEXP },
  { ":delete", NULL, KEYWORD_SEXP },
  { ":replace", NULL, KEYWORD_SEXP },
  { ":tag", NULL, KEYWORD_GET_SEXP },
  { ":key", NULL, KEYWORD_GET_SEXP },
  { ":enable", NULL, KEYWORD_SEXP },
  { ":disable", NULL, KEYWORD_SEXP },
  { ":sensitive", KEYWORD_NONE, KEYWORD_FLAG },
};

void
MenuUpdate(self,sexp)
     t_menu_widget self;
     t_sexp sexp;
{
  t_sexp s_title, s_add, s_delete, s_replace;
  t_sexp s_item, s_tag, s_key, s_enable, s_disable;
  t_keyword_flag sensitive;
  char *title;
  t_generic_widget items, item;

  UpdateWidgetList(self->items, sexp);
  if (!MBequal(MBnth(sexp, 1), self->id)) return;

  MBparse_keywords(MBnthcdr(sexp, 2), mukw, ARRAY_SIZE(mukw));
  s_title = (t_sexp) mukw[0].result;
  s_add = (t_sexp) mukw[1].result;
  s_delete = (t_sexp) mukw[2].result;
  s_replace = (t_sexp) mukw[3].result;
  s_tag = (t_sexp) mukw[4].result;
  s_key = (t_sexp) mukw[5].result;
  s_enable = (t_sexp) mukw[6].result;
  s_disable = (t_sexp) mukw[7].result;
  sensitive = (t_keyword_flag) mukw[8].result;

  if (NULL != s_tag)
    {
      MBfree(self->tag);
      self->tag = s_tag;
    }

  if (NULL != s_key)
    {
      MBfree(self->key);
      self->key = s_key;
    }

  if (KEYWORD_TRUE == sensitive) XtSetSensitive(self->widget, True);
  if (KEYWORD_FALSE == sensitive) XtSetSensitive(self->widget, False);

  if (NULL != s_title)
    {
      if (NULLP(s_title))
	{
	  XtUnmanageChild(self->title_widget);
	  XtUnmanageChild(self->separator_widget);
	}
      else
	{
	  title = MBCstring(s_title);
	  SetTitle(self->title_widget, title);
	  XtManageChild(self->title_widget);
	  XtManageChild(self->separator_widget);
	  XtFree(title);
	}
    }

  if (NULL != s_replace)
    {
      MBfree(s_add); s_add = NULL;
      MBfree(s_delete); s_delete = NULL;
      items = MenuHandleItems(self, s_replace);
      if (NULL != items)
	{
	  for ( item = self->items; NULL != item ; item = item->next )
	    XtDestroyWidget(item->widget);
	  RemoveWidgetList(self->items);
	  self->items = items;
	  ManageWidgetList(items);
	}
    }

  if (NULL != s_add)
    {
      items = MenuHandleItems(self, s_add);
      if (NULL != items)
	{
	  /* clean out any previous versions */
	  for ( item = items ; NULL != item ; item = item->next )
	    MenuDeleteItem(self, item->id);
	  /* add the new ones in */
	  ManageWidgetList(items);
	  /* Yuck, but I don't see a better way */
	  for ( item = items ; NULL != item->next ; item = item->next )
	    ;
	  item->next = self->items;
	  self->items = items;
	}
    }

  for ( s_item = s_delete ; NULL != s_item ; s_item = MB_CDR(s_item))
    if (MB_STRINGP(s_item) || MB_NAMEP(s_item))
      MenuDeleteItem(self, s_item);
    else MenuDeleteItem(self, MB_CAR(s_item));

  for ( s_item = s_enable ; NULL != s_item ; s_item = MB_CAR(s_item))
    if (MB_STRINGP(s_item) || MB_NAMEP(s_item))
      ChildSetSensitive(self->items, s_item, True);
    else ChildSetSensitive(self->items, MB_CAR(s_item), True);

  for ( s_item = s_disable ; NULL != s_item ; s_item = MB_CAR(s_item))
    if (MB_STRINGP(s_item) || MB_NAMEP(s_item))
      ChildSetSensitive(self->items, s_item, False);
    else ChildSetSensitive(self->items, MB_CAR(s_item), False);
}
/* ------------------------------------------------------------------------ */
/* Transmit data to the MBus */
void
MenuTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_menu_widget self;
{
  TransmitWidgetList(message, orig_reply, self->items);
}
/* ------------------------------------------------------------------------ */
void
MenuEditable(self,flag)
     t_menu_widget self;
     int flag;
{
  EditableWidgetList(self->items, flag);
}
/* ------------------------------------------------------------------------ */
/* Called by a child when it decides to destroy itself for whatever reason.
 * We should update our internal data to remove references to the child.
 * Assume that all of the childs internal and widgets stuff is taken care
 * of by the child.
 */
void
MenuChildRemoved(self, child)
     t_menu_widget self;
     t_generic_widget child;
{
  /* I guess the only thing to do is remove the child from the list of
   * items in the menu */
  self->items = RemoveChildFromList(self->items, child);
}
/* ------------------------------------------------------------------------ */
void
MenuReply(self, reply)
     t_menu_widget self;
     t_mbus_reply reply;
{
  if (NULL == reply->key && NULL != self->key)
    reply->key = MBprint_Cstring(self->key);
  if (NULL == reply->tag && NULL != self->tag)
    reply->tag = MBprint_Cstring(self->tag);
  if (NULL == reply->header && NULL != self->header)
    reply->header = strdup(self->header);
  if (NULL == reply->context && NULL != self->context)
    reply->context = ContextString(self->context);
  reply->wrap = self->wrap;

  if (NULL != self->parent)
    self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
MenuRealized(self) t_menu_widget self;
{
  t_generic_widget item;

  for ( item = self->items ; NULL != item ; item = item->next )
    item->class->realized(item);
}
/* ------------------------------------------------------------------------ */
