/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	button.c: The button widget */
/* widget server button support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node108.text,v $ */

static char rcsid[] = "button.c $Revision: 1.1 $ $Date: 92/05/08 15:26:16 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
/* This used to be:
 *#include <Xm/PushBG.h>
 *#include <Xm/CascadeBG.h>
 * Changed away from this to get colors on our buttons.
 */
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/SelectioB.h>
/* ------------------------------------------------------------------------ */
extern void
  ButtonRemove(), ButtonUpdate(), ButtonReply(), ButtonRealized(),
  ButtonTransmit(), ButtonEditable();

extern t_generic_widget ButtonHandle();

extern Pixel GetColor();
extern XFontStruct *GetFont();

struct widget_class_struct ButtonClassRecord =
{
  WS_BUTTON, "button",
  ButtonHandle, ButtonRemove, NULL, ButtonUpdate, ButtonReply,
  ButtonRealized, ButtonTransmit, ButtonEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct button_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  char *key;				/* reply key */
  char *value;				/* reply value */
  char *tag;				/* reply tag */
  char *header;				/* header for reply */
  t_generic_widget prompt;		/* prompt widget, if one */
  t_sexp action;			/* action sexp, if any */
  Boolean local;			/* local actions flag */
  Boolean with_parent_values;		/* use :values from parent? */
  Boolean with_top_values;		/* use :values from top? */
  XmFontList font_list;
} * t_button_widget;
/* ------------------------------------------------------------------------ */
/* This is called when the button is activated by the user */
void
ButtonCallback(w, button, data)
     Widget w;
     t_button_widget button;
     caddr_t data;
{
  Position x, y;

  /* Several things can be done
   *  If there's an action, execute it.
   *  Otherwise, generate a reply to put on the MBus.
   */
  if (NULL != button->action) Act(button, button->action, button->local);
  else ReplyCallback(w, button, data);
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct ButtonKeywords[] =
{
  { ":value", NULL, KEYWORD_RAW },
  { ":key", NULL, KEYWORD_RAW },
  { ":tag", NULL, KEYWORD_RAW },
  { ":action", NULL, KEYWORD_GET_SEXP },
  { ":sensitive", (void *)KEYWORD_NONE, KEYWORD_FLAG },
  { ":local", (void *)KEYWORD_NONE, KEYWORD_FLAG },
  { ":values", NULL, KEYWORD_SEXP },
  { ":mnemonic", NULL, KEYWORD_COOKED },
  { ":with-values", NULL, KEYWORD_SEXP },
  { ":header", NULL, KEYWORD_COOKED },
  { ":foreground", NULL, KEYWORD_COOKED },
  { ":font", NULL, KEYWORD_COOKED },
};

t_generic_widget
ButtonHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_button_widget button;
  char *label, *mnemonic, *foreground_name, *font_name;
  t_keyword_flag sensitive;
  t_sexp s_with_values;
  XmString xm_label;
  int n;
  Arg argl[10];
  Pixel foreground;
  XFontStruct * font;
  XmFontList font_list = NULL;

  if (NULL == parent || NULL == sexp) return NULL;

  button = NEW_STRUCT(button_widget_struct);
  button->type = WS_BUTTON;
  button->class = &ButtonClassRecord;
  button->parent = parent;
  button->top = parent->top;
  button->id = Getnth(sexp, 1);
  button->next = NULL;
  button->prompt = NULL;
  button->with_parent_values = button->with_top_values = False;

  /* sexp should be (button "id" "label" &key key value) */
  MBparse_keywords(MBnthcdr(sexp,3), ButtonKeywords, ARRAY_SIZE(ButtonKeywords));
  n = 0;
  button->value = (char *)ButtonKeywords[n++].result;
  button->key = (char *)ButtonKeywords[n++].result;
  button->tag = (char *)ButtonKeywords[n++].result;
  button->action = (t_sexp)ButtonKeywords[n++].result;
  sensitive = (t_keyword_flag)ButtonKeywords[n++].result;
  button->local = KEYWORD_TRUE == (t_keyword_flag)ButtonKeywords[n++].result;
  button->values = ContextString((t_sexp)ButtonKeywords[n++].result);
  mnemonic = (char *)ButtonKeywords[n++].result;
  s_with_values = (t_sexp)ButtonKeywords[n++].result;
  button->header = (char *)ButtonKeywords[n++].result;
  foreground_name = (char *)ButtonKeywords[n++].result;
  font_name = (char *)ButtonKeywords[n++].result;

  /* Create a push button unless the parent is a menu bar, in which case
   * we need to use a cascade button
   */
  label = MBCstring(MBnth(sexp,2));
  xm_label = CtoXmString(label);
  n = 0;
  XtSetArg(argl[n], XmNlabelString, xm_label), ++n;
  if (KEYWORD_FALSE == sensitive) XtSetArg(argl[n], XmNsensitive, False), ++n;
  if (NULL != mnemonic)
    {
      KeySym keysym = XStringToKeysym(mnemonic);
      if (NoSymbol != keysym)
	XtSetArg(argl[n], XmNmnemonic, keysym), ++n;
    }

  for ( ; NULL != s_with_values ; s_with_values = MB_CDR(s_with_values))
    {
      t_sexp tag;
      if (MB_CONSP(s_with_values)) tag = MB_CAR(s_with_values);
      else tag = s_with_values;
      if (!MBcompare_Cstring(tag, ":top")) button->with_top_values = True;
      else if (!MBcompare_Cstring(tag, ":top"))
	button->with_parent_values = True;
    }

  if (foreground_name)
  {
    foreground = GetColor(toplevel_widget, foreground_name);
    XtSetArg(argl[n], XmNforeground, foreground), ++n;
    FREE(foreground_name);
  }
  button->font_list = NULL;
  if (font_name)
  {
    font = GetFont(toplevel_widget, font_name);
    if (font)
    {
      /* Don't know here if we can simply free the font_list as soon as
       * we give it to motif.  Thus, we will keep it with the button and
       * free it when the button goes away.  We know that is safe.
       */
      button->font_list = XmFontListCreate (font, XmSTRING_DEFAULT_CHARSET);
      XtSetArg(argl[n], XmNfontList, button->font_list), ++n;
    }
    FREE(font_name);
  }

  /* This used to be creating ButtonGadget classes instead of ButtonWidget 
   * classes.  Changed so we could have colors on our buttons.
   */
  button->widget =
    XtCreateWidget("button",
		   parent->type == WS_MENU_BAR ?
		   xmCascadeButtonWidgetClass : xmPushButtonWidgetClass,
		   parent->widget, argl, n);

  XtAddCallback(button->widget, XmNactivateCallback, ButtonCallback, button);
  XtFree(label);
  XmStringFree(xm_label);
  XtFree(mnemonic);

  return (t_generic_widget)button;
}
/* ------------------------------------------------------------------------ */
void
ButtonRemove(self) t_button_widget self;
{
  if (self->font_list) XmFontListFree(self->font_list);
  MBfree(self->id);
  MBfree(self->action);
  XtFree(self->key);
  XtFree(self->value);
  XtFree(self->values);
  XtFree(self->tag);
  XtFree(self->header);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the button */
static struct keyword_entry_struct ButtonUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },	/* change label */
  { ":tag", NULL, KEYWORD_RAW },	/* change tag */
  { ":value", NULL, KEYWORD_RAW },	/* change value */
  { ":delete", NULL, KEYWORD_SEXP },	/* delete ourself */
  { ":sensitive", KEYWORD_NONE, KEYWORD_FLAG}, /* set sensitivity */
  { ":header", NULL, KEYWORD_COOKED },	/* change header */
};

void
ButtonUpdate(self,sexp)
     t_button_widget self;
     t_sexp sexp;
{
  XmString xm_string;
  char *label, *tag, *value, *header;
  t_sexp s_delete;
  t_keyword_flag sensitive;
  int n;

  if (!MBequal(MBnth(sexp,1), self->id)) return;

  MBparse_keywords(MBnthcdr(sexp,2), ButtonUpdateKeys,
		ARRAY_SIZE(ButtonUpdateKeys));
  n = 0;
  label = (char *)ButtonUpdateKeys[n++].result;
  tag = (char *)ButtonUpdateKeys[n++].result;
  value = (char *)ButtonUpdateKeys[n++].result;
  s_delete = (t_sexp)ButtonUpdateKeys[n++].result;
  sensitive = (t_keyword_flag)ButtonUpdateKeys[n++].result;
  header = (char *)ButtonUpdateKeys[n++].result;

  if (!MBcompare_Cstring(s_delete, ":self"))
    {
      /* Time to head for that big bit bucket in the sky */
      XtDestroyWidget(self->widget);
      self->parent->class->child_remove(self->parent, self);
      ButtonRemove(self);
      XtFree(label); XtFree(tag); XtFree(value);
      return;
    }

  if (NULL != label)
    {
      Arg argl[1];

      xm_string = XmStringCreate(label, XmSTRING_DEFAULT_CHARSET);
      XtSetArg(argl[0], XmNlabelString, xm_string);
      XtSetValues(self->widget, argl, XtNumber(argl));
      XmStringFree(xm_string);
    }

  if (NULL != tag) XtFree(self->tag), self->tag = tag;
  if (NULL != value) XtFree(self->value), self->value = value;
  if (NULL != header) XtFree(self->header), self->header = header;
  if (KEYWORD_TRUE == sensitive) XtSetSensitive(self->widget, True);
  if (KEYWORD_FALSE == sensitive) XtSetSensitive(self->widget, False);

  XtFree(label);
}
/* ------------------------------------------------------------------------ */
void
ButtonReplyValueHook(message, orig_reply, button)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_button_widget button;
{
  if (NULL != button->values)
      MBput_Cstring(message, button->values);
  if (button->with_parent_values)
      MBput_Cstring(message, button->parent->values);
  if (button->with_top_values)
      MBput_Cstring(message, button->top->values);
}
/* ------------------------------------------------------------------------ */
/* Called when the button has been activated and should send a reply on
 * the MBUS.
 */
void
ButtonReply(self, reply)
     t_button_widget self;
     t_mbus_reply reply;
{
  /* If something's missing and we've got it, fill it in */
  if (NULL == reply->key) reply->key = strdup(self->key);
  if (NULL == reply->value) reply->value = strdup(self->value);
  if (NULL == reply->tag) reply->tag = strdup(self->tag);
  if (NULL == reply->header) reply->header = strdup(self->header);
  reply->hook = ButtonReplyValueHook;
  reply->hook_data = (void *)self;
  /* fill in anything else from our ancestors */
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
ButtonRealized(self) t_button_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
ButtonTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_button_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
ButtonEditable(self, flag)
     t_button_widget self;
     int flag;
{
}
/* ------------------------------------------------------------------------ */
