/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	api.h: Applications Interface header file */
/* Structures for the API */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/lib/RCS/api.h,v $ */

/* $Revision: 2.1.1.2 $
 * $Date: 91/11/15 13:35:17 $
 * $State: Exp $
 * $Author: carroll $
 */

/* This file contains all of the definitions needed to interface with the
 * MBus library. Library objects are set up as opaque types. If internal
 * access is needed, then the file mbus.h should also be included, before
 * this file.
 */

#ifndef MB_API_H
#define MB_API_H
/* ------------------------------------------------------------------------- */
/* Value returned when data is requested from a Chunk (or Sexp) and there
 * is no data.
 */
#define CHUNK_EMPTY (-1)

/* Meta characters for regular expressions, in case someone wants to check
 * a character before hand.
 */
#define MB_REGEXP_META "^$.[()|?+*\\"
#define MB_REGEXP_IS_META(c)	(NULL != strchr(MB_REGEXP_META,(c)))

typedef struct mb_connection_struct * t_mb_connection;
typedef struct mb_object * t_sexp;
/* This is silly, but I can't find a portable way to stick malloc() into
 * a function pointer, so I have to get ugly.
 */
typedef void *t_malloc;

#ifdef __STDC__
extern t_malloc malloc(unsigned int);
extern int free(void *);

extern t_sexp MBparse_connection(t_mb_connection);
extern int MBread_connection(t_mb_connection);
extern int MBcheck_connection(t_mb_connection);
extern t_sexp MBNextMessage(t_mb_connection);
extern t_mb_connection MBConnect(char *, int);
extern void MBLostConnection(t_mb_connection);
extern int MBtransmit_buffer(t_mb_connection, char *, int);
extern int MBconnection_fd(t_mb_connection);

extern void (*mb_lost_connection_function)(t_mb_connection);

extern t_malloc (*MBmalloc_func)(unsigned int);
extern int (*MBfree_func)(void *);

extern t_sexp MBGetName();
extern t_sexp MBGetString();
extern t_sexp MBGetCons();

extern t_sexp MBcar(t_sexp);
extern t_sexp MBcdr(t_sexp);
extern t_sexp MBsetcar(t_sexp, t_sexp);
extern t_sexp MBsetcdr(t_sexp, t_sexp);
extern t_sexp MBnth(t_sexp, int);
extern t_sexp MBnthcdr(t_sexp, int);
extern int MBlength(t_sexp);
extern int MBconsp(t_sexp);
extern int MBstringp(t_sexp);
extern int MBchunkp(t_sexp);
extern int MBemptyp(t_sexp);
extern void MBempty(t_sexp);

extern t_sexp MBduplicate(t_sexp);

extern t_sexp MBprint(t_sexp, t_sexp);
extern t_sexp MBput_Cstring(t_sexp, char *);
extern t_sexp MBput_char(t_sexp, char);
extern t_sexp MBput(t_sexp, t_sexp);
extern char *MBCstring(t_sexp);
extern char *MBCsubstring(t_sexp, int, int);
extern char *MBprint_Cstring(t_sexp);

extern t_sexp MBRegexpCompile(t_sexp);

extern char *MBstrdup(char *);

extern int MBint(t_sexp, int *);

extern t_sexp MBparse_Cstring(char *);

#else

extern t_malloc malloc();
extern int free();

extern t_sexp MBNextMessage();
extern t_sexp MBparse_connection();
extern int MBread_connection();
extern int MBcheck_connection();
extern t_mb_connection MBConnect();
extern void MBLostConnection();
extern int MBtransmit_buffer();
extern int MBwrite();
extern int MBconnection_fd();

extern void (*mb_lost_connection_function)();

extern t_malloc (*MBmalloc_func)();
extern int (*MBfree_func)();

extern t_sexp MBGetName();
extern t_sexp MBGetString();
extern t_sexp MBGetCons();

extern t_sexp MBcar();
extern t_sexp MBcdr();
extern t_sexp MBsetcar();
extern t_sexp MBsetcdr();
extern t_sexp MBnth();
extern t_sexp MBnthcdr();
extern int MBlength();
extern int MBconsp();
extern int MBstringp();
extern int MBchunkp();
extern int MBemptyp();
extern void MBempty();

extern t_sexp MBduplicate();

extern t_sexp MBprint();
extern t_sexp MBput_Cstring();
extern t_sexp MBput_char();
extern t_sexp MBput();
extern char *MBCstring();
extern char *MBCsubstring();
extern char *MBprint_Cstring();

extern t_sexp MBRegexpCompile();

extern char *MBstrdup();

extern int MBint();

extern t_sexp MBparse_Cstring();
#endif

extern t_sexp MBGetRaw();

/* ------------------------------------------------------------------------- */
/* Externally visible data objects */

extern t_sexp MBnil;		/* the nil object */
#define MB_FREEP(o) ((o) != NULL && (o)->next != MBnil)

extern int MBLogLevel;

#ifdef __STDC__
extern struct mb_object *(*MBraw_filter)(char *, int, int);
#else
extern struct mb_object *(*MBraw_filter)();
#endif
/* ------------------------------------------------------------------------- */
#endif /* MB_API_H */
