/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* Send a file to the MBus */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/commands/RCS/mbsend.c,v $ */

static char rcsid[] = "mbsend.c $Revision: 2.1.1.1 $ $Date: 91/11/15 13:37:58 $ $State: Exp $ $Author: carroll $";

/* ------------------------------------------------------------------------- */
#include "header.h"
#include "getopt.h"
#include "cb-defs.h"
#include <signal.h>

int MBLogLevel = 0;
extern int errno;

char *host = NULL;
int port = DEF_MBUS_PORT;

/* ------------------------------------------------------------------------- */
int
DealWithCommandLine(argc,argv)
     int argc;
     char **argv;
{
  int opt;
  char *tmp;
  char useage = 0;
  extern char *getenv();

  /* environment variable checks */
  host = getenv(ENV_MBUS_HOST);
  if (NULL != (tmp = getenv(ENV_MBUS_PORT))) port = strtol(tmp, NULL, 0);

  while ( (opt = getopt(argc,argv,"h:p:")) != EOF)
    switch (opt)
      {
      case '?' :
	fprintf(stderr,"%c\tBad option\n",opt_err_char);
	useage = 1;
	break;
      case 'h' : host = optarg; break;
      case 'p' :
	{
	  int n;
	  char *s;
	  n = strtol(optarg, &s, 0);
	  if (s != optarg) port = n;
	}
	break;
      }

  return optind;
}
/* ------------------------------------------------------------------------- */
void
SendFile(c,name)
     t_mb_connection c;
     char *name;
{
  FILE *f;
  int count;
  char buff[4096];

  if (NULL == (f = fopen(name,"r")))
    {
      fprintf(stderr,"Cannot open file ");
      perror(name);
      return;
    }

  while ( (count = fread(buff, sizeof(char), 4096, f)) > 0)
    MBtransmit_buffer(c, buff, count);
 
  fclose(f);
}
/* ------------------------------------------------------------------------- */
void
JustExit(c) t_mb_connection c;
{
  exit(0);
}
/* ------------------------------------------------------------------------- */
static char hello_message [] = "(id \"File Sender\")";
static char goodbye_message [] = "(close)";

main(argc,argv)
     int argc;
     char *argv[];
{
  t_mb_connection c;
  int skip;

  skip = DealWithCommandLine(argc,argv);

  if ((argc - skip) < 1)
    {
      fprintf(stderr,"Usage: %s -h host -p port file ...\n",argv[0]);
      exit(1);
    }

  if (NULL == (c = MBConnect(host,port)))
    {
      fprintf(stderr,"Couldn't connect to MBus at %s, %d\n",
	      NULL == host ? "*empty*" : host, port);
      exit(1);
    }

  /* Stupid SysV R4 is brain dead, and generates unrequested SIGPOLL's
   * if a socket becomes unfull during a poll(). Yargh.
   */
#ifdef SIGPOLL
  signal(SIGPOLL,SIG_IGN);
#endif

  MBtransmit_buffer(c, hello_message, sizeof(hello_message) -1);

  for ( ; skip < argc ; skip += 1 )
    SendFile(c,argv[skip]);

  MBtransmit_buffer(c, goodbye_message, sizeof(goodbye_message)-1);
  mb_lost_connection_function = JustExit;
  while (1)
    {
      MBNextMessage(c);
      sleep(1);
    }
}
/* ------------------------------------------------------------------------- */
