;;; This file is part of the
;;;
;;;      Delta Project  (ConversationBuilder)
;;;      Human-Computer Interaction Laboratory
;;;      University of Illinois at Urbana-Champaign
;;;      Department of Computer Science
;;;      1304 W. Springfield Avenue
;;;      Urbana, Illinois 61801
;;;      USA
;;;
;;;      c 1989,1990,1991 Board of Trustees
;;;              University of Illinois
;;;              All Rights Reserved
;;;
;;;      This file is distributed under license and is confidential
;;;
;;;      Author:  Simon Kaplan (kaplan@cs.uiuc.edu)
;;;               Alan Carroll (carroll@cs.uiuc.edu)
;;;
;;;      Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
;;;      Direct enquiries to the project leader please.
;;;

(require 'cl)
;;;
;;; Attempt to make starting up MBUS easier
;;;

(defvar DEF_MBUS_PORT 2650)
(defvar ENV_MBUS_PORT "MBUS_PORT")
(defvar ENV_MBUS_HOST "MBUS_HOST")

(defvar mbus:*bus-domains* "" "Quoted string of interesting domains" ) 

(defvar mbus:*user-name* (user-login-name) "User name" )

(defvar mbus:*host*
  (or (getenv ENV_MBUS_HOST) (system-name))
  "Hostname of the message bus"
)

(defvar mbus:*port*
  (or
    (let ((port (getenv ENV_MBUS_PORT)))
      (and (stringp port) (car (read-from-string port)))
    )
    DEF_MBUS_PORT
  )
  "Port number of the message bus"
)

(defvar mbus:*server-name* "MBUS" "Name of the MBus process")
(defvar mbus:*server* nil "MBus server process object")
(defvar mbus:*server-buffer* (get-buffer-create " *MBUS*") "CB server buffer")
(defvar mbus:*temp-buffer* (get-buffer-create " *MBUS-Temp*") "Scratch buffer")
(defvar mbus:*server-mark* (make-marker) "Process buffer mark")
(defvar mbus:*xa-dispatch* (intern-atom "MBUS_DISPATCH")
  "Property to set to indicate that the dispatcher should run"
)

(defvar *mbus-dispatch-dispatch* nil
  "The primary dispatch list. Should be an alist of (KEY . HANDLER) pairs"
)

(defvar xa-mbus-status (intern-atom "MBUS_STATUS"))
(defvar *mbus-status-stack* nil)
(defvar *mbus-noisy* nil)
(defvar *mbus-log* nil)

(load "bus")
(load "engine")

(setq window-min-height 2)

(provide 'mbus)

