/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Amounts } from "@gnu-taler/taler-util";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Amount } from "../../components/Amount.js";
import { Part } from "../../components/Part.js";
import { Button } from "../../mui/Button.js";
import { State } from "./index.js";

/**
 *
 * @author sebasjm
 */

export function InsertLostView(state: State.InsertLost): VNode {
  const { i18n } = useTranslationContext();
  return <Fragment>
    <section>
      <Part
        title={i18n.str`Experiment`}
        text={i18n.str`Insert lost denomination`}
      />
    </section>
    <section>
      <Button
        variant="contained"
        color="success"
        onClick={state.confirm.onClick}
      >
        <i18n.Translate>Apply</i18n.Translate>
      </Button>
    </section>
  </Fragment>
}

export function InsertPendingRefreshView(state: State.PendingRefresh): VNode {
  const { i18n } = useTranslationContext();
  return <Fragment>
    <section>
      <Part
        title={i18n.str`Experiment`}
        text={i18n.str`Pending refresh`}
      />
    </section>
    <section>
      <Button
        variant="contained"
        color="success"
        onClick={state.confirm.onClick}
      >
        <i18n.Translate>Apply</i18n.Translate>
      </Button>
    </section>
  </Fragment>
}

export function UnknownView(state: State.Unknown): VNode {
  return <div>unknown experiment "{state.experimentId}"</div>
}
