/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { FunctionalComponent, h } from "preact";
import { UpdatePage as TestedComponent } from "./UpdatePage.js";

export default {
  title: "Pages/Instance/Update",
  component: TestedComponent,
  argTypes: {
    onUpdate: { action: "onUpdate" },
    onBack: { action: "onBack" },
  },
};

function createExample<Props>(
  Component: FunctionalComponent<Props>,
  props: Partial<Props>,
) {
  const r = (args: any) => <Component {...args} />;
  r.args = props;
  return r;
}

export const Example = createExample(TestedComponent, {
  selected: {
    name: "name",
    auth: { method: "external" },
    address: {},
    user_type: "business",
    use_stefan: true,
    jurisdiction: {},
    default_pay_delay: {
      d_us: 1000 * 1000, //one second
    },
    default_wire_transfer_delay: {
      d_us: 1000 * 1000, //one second
    },
    merchant_pub: "ASDWQEKASJDKSADJ",
  },
});
