/*
 This file is part of GNU Anastasis
 (C) 2021-2022 Anastasis SARL

 GNU Anastasis is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Anastasis is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License along with
 GNU Anastasis; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import * as tests from "@gnu-taler/web-util/testing";
import { reducerStatesExample } from "../../../utils/index.js";
import { authMethods as TestedComponent, KnownAuthMethods } from "./index.js";

export default {
  title: "Auth method: Question setup",
  component: TestedComponent,
  args: {
    order: 5,
  },
  argTypes: {
    onUpdate: { action: "onUpdate" },
    onBack: { action: "onBack" },
  },
};

const type: KnownAuthMethods = "question";

export const Empty = tests.createExample(
  TestedComponent[type].setup,
  {
    configured: [],
  },
  reducerStatesExample.authEditing,
);

export const WithOneExample = tests.createExample(
  TestedComponent[type].setup,
  {
    configured: [
      {
        challenge: "qwe",
        type,
        instructions:
          "Is integer factorization polynomial? (non-quantum computer)",
        remove: () => null,
      },
    ],
  },
  reducerStatesExample.authEditing,
);

export const WithMoreExamples = tests.createExample(
  TestedComponent[type].setup,
  {
    configured: [
      {
        challenge: "qwe",
        type,
        instructions: "Does P equal NP?",
        remove: () => null,
      },
      {
        challenge: "asd",
        type,
        instructions:
          "Are continuous groups automatically differential groups?",
        remove: () => null,
      },
    ],
  },
  reducerStatesExample.authEditing,
);
