/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import type { AbsoluteTime } from "@gnu-taler/taler-util";
import type { InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "../context/ui-forms.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) => ({
  design: [
    {
      title:
        i18n.str`Information on life insurance policies with separately managed accounts/securities accounts`,
      fields: [
        {
          type: "textArea",
          properties: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "text",
          properties: {
            name: "contractualRelationship",
            label:
              i18n.str`Name or number of the contractual relationship between the contracting party and the financial intermediary`,
          },
        },
        {
          type: "text",
          properties: {
            name: "insurancePolicy",
            label: i18n.str`Insurance policy`,
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`The contracting partner confirms in accordance with Art. 41a SRO Regulations that it is a licensed and state-supervised insurance company and that it has entered into the above-mentioned contractual relationship the assets connected to the life insurance policy also mentioned above.`,
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`In relation with the above insurance policy, the contracting partner gives the following further details`,
          },
        },
        {
          type: "group",
          properties: {
            before: i18n.str`Policy holder`,
            fields: [
              {
                type: "text",
                properties: {
                  name: "holder.fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "holder.address",
                  label:
                    i18n.str`Actual address of domicile/registered office (incl. country)`,
                },
              },
              {
                type: "absoluteTime",
                properties: {
                  name: "holder.dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "holder.nationality",
                  label: i18n.str`Nationality`,
                },
              },
            ],
          },
        },
        {
          type: "group",
          properties: {
            before:
              i18n.str`Person actually (not in a fiduciary capacity) paying the premiums (to be filled in if not identical with point 1 above)`,
            fields: [
              {
                type: "text",
                properties: {
                  name: "premiumPayer.fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "premiumPayer.address",
                  label:
                    i18n.str`Actual address of domicile/registered office (incl. country)`,
                },
              },
              {
                type: "absoluteTime",
                properties: {
                  name: "premiumPayer.dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "premiumPayer.nationality",
                  label: i18n.str`Nationality`,
                },
              },
            ],
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`The contracting partner hereby undertakes to automatically inform the financial intermediary of any changes. The contracting partner hereby also declares having been given permission by the above individuals and/or entities to transmit their data to the financial intermediary`,
          },
        },
        {
          type: "text",
          properties: {
            name: "signature",
            label: i18n.str`Signature`,
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)`,
          },
        },
      ],
    },
    resolutionSection(i18n),
  ],
});

namespace Form902_15 {
  interface Person {
    fullName: string;
    address: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }

  export interface Form extends BaseForm {
    contractingPartner: string;
    contractualRelationship: string;
    insurancePolicy: string;
    holder: Person;
    premiumsPayer: Person;
    signature: string;
  }
}
