/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRHISTORYPROC_H_
#define _VRHISTORYPROC_H_

#include <VrSigProc.h>

// VrSigProc with history.  Set the history variable in initialize()
// to the maximum history that will ever be needed.
template<class iType, class oType> 
class VrHistoryProc : public VrSigProc {
protected:
  unsigned int history;

public: 
  VrHistoryProc(int outputs) : VrSigProc(outputs, sizeof(iType), sizeof(oType)), history(1) {}
  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);
  virtual unsigned int mapSizeUp(int i, unsigned int size);
  virtual ~VrHistoryProc() {}
};

template<class iType,class oType> int
VrHistoryProc<iType,oType>::forecast(VrSampleRange output,
				     VrSampleRange inputs[]) {
  /* 1:1 ratio with history */
  for(unsigned int i=0;i<numberInputs;i++) {
    inputs[i].index=output.index; /* ! do not subtract history ! */
    inputs[i].size=output.size + history-1;
  }
  return 0;
}  

template<class iType,class oType> unsigned int
VrHistoryProc<iType,oType>::mapSizeUp(int i, unsigned int size) {
  return (unsigned int) (size *
	 (getUpstreamModuleN(i)->getSamplingFrequency()
	  /getSamplingFrequency())+history-1);
}
#endif
