/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <make_GrMC4020Source.h>
#include <config.h>

#ifdef HAVE_MC4020
#include <GrMC4020Source.h>

// produce a stream of shorts from the A/D
VrSource<short> *
make_GrMC4020SourceS (double sampling_freq, unsigned long bitmask)
{
  return new GrMC4020Source<short>(sampling_freq, bitmask);
}


#else

#include <stdlib.h>
#include <iostream>

// produce a (fake) stream of shorts from the A/D
VrSource<short> *
make_GrMC4020SourceS (double sampling_freq, unsigned long bitmask)
{
  std::cerr << "Error: mc4020.h not detected at configure time.  GrMC4020Source disabled.\n";
  std::cerr << "  At configure time we expect to find /usr/local/include/mc4020.h if you've\n";
  std::cerr << "  installed the mc4020 driver.  Do you have the driver?\n";
  exit (1);

  return 0;
}

#endif
