/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mac;

import gnu.crypto.Registry;
import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mac.BaseMac;
import gnu.crypto.mac.HMacFactory;
import gnu.crypto.mac.IMac;
import gnu.crypto.mac.OMAC;
import gnu.crypto.mac.TMMH16;
import gnu.crypto.mac.UHash32;
import gnu.crypto.mac.UMac32;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MacFactory
implements Registry {
    private static Set names;
    static /* synthetic */ Class class$gnu$crypto$mac$MacFactory;

    public static IMac getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        if ((name = name.toLowerCase()).startsWith("hmac-")) {
            return HMacFactory.getInstance(name);
        }
        if (name.startsWith("omac-")) {
            IBlockCipher cipher = CipherFactory.getInstance(name = name.substring("omac-".length()));
            if (cipher == null) {
                return null;
            }
            return new OMAC(cipher);
        }
        BaseMac result = null;
        if (name.equalsIgnoreCase("uhash32")) {
            result = new UHash32();
        } else if (name.equalsIgnoreCase("umac32")) {
            result = new UMac32();
        } else if (name.equalsIgnoreCase("tmmh16")) {
            result = new TMMH16();
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Set getNames() {
        Class clazz = class$gnu$crypto$mac$MacFactory;
        if (clazz == null) {
            clazz = class$gnu$crypto$mac$MacFactory = MacFactory.class("[Lgnu.crypto.mac.MacFactory;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            block6: {
                if (names != null) break block6;
                HashSet<String> hs = new HashSet<String>();
                hs.addAll(HMacFactory.getNames());
                hs.add("uhash32");
                hs.add("umac32");
                hs.add("tmmh16");
                Iterator it = CipherFactory.getNames().iterator();
                while (true) {
                    if (!it.hasNext()) {
                        names = Collections.unmodifiableSet(hs);
                        break;
                    }
                    hs.add("omac-" + it.next());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private MacFactory() {
    }
}

