/*
 * Electric(tm) VLSI Design System
 *
 * File: ioecado.c
 * Input/output aid: ECAD output
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "config.h"
#if IOECAD

#include "global.h"
#include "eio.h"

INTSML io_writeecadlibrary(LIBRARY *lib)
{
#if 0		/* ecad not implemented yet */
	char file[100], *truename;
	REGISTER char *name;
	REGISTER NODEPROTO *np;

	/* create the proper disk file for the ECAD */
	np = lib->curnodeproto;
	if (np == NONODEPROTO)
	{
		ttyputerr(_("Must be editing a facet to generate ECAD output"));
		return(1);
	}
	(void)strcpy(file, np->cell->cellname);
	(void)strcat(file, ".asc");
	name = truepath(file);
	io_fileout = xcreate(name, io_filetypeecad, _("ECAD File"), &truename);
	if (io_fileout == NULL)
	{
		if (truename != 0) ttyputerr(_("Cannot write %s"), truename);
		return(1);
	}
	xprintf(io_fileout, ";; ECAD for library %s\n", lib->libname);

	/* clean up */
	xclose(io_fileout);

	/* tell the user that the file is written */
	ttyputmsg(_("%s written"), truename);
#else
	ttyputerr(_("Cannot write ECAD netlists yet"));
#endif
	return(0);
}

#endif  /* IOECAD - at top */
