#!/usr/bin/perl
# Copyright (C) 2005 Open Source Telecom Corp.
#
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# Basic perl script for testing of libexec subsystem and use of
# Bayonne::Libexec perl module.

# this is needed if test script is executed directly (outside Bayonne)
use lib '../scripts';

# get Bayonne libexec package under Bayonne server (PERL5LIB ref)
use libexec;

# create $TGI instance of libexec (based on future cpan mapping...)
$TGI = new Bayonne::Libexec;

# get tgi version, and print it (sent to stderr if in tgi). 
$ver=$TGI->{version};
$TGI->print("TGI VERSION $ver\n"); 

# see if we are running under bayonne, or just stand-alone
if(!$TGI->{tsession}) {
	print STDERR "*** Started in local execution mode, exiting...\n";
	exit
}

my $pin = $TGI->{args}{PIN};
$TGI->print("TIMEOUT FROM HEADER IS $TGI->{head}{TIMEOUT}\n");
$TGI->print("PIN NUMBER PASSED IS $pin\n");
my $result = $TGI->prompt("&number $pin");

$TGI->print("COMMAND RESULT $result\n");
$TGI->print("LAST COMMAND RESULT BEFORE EXIT $TGI->{result}\n");
$TGI->result("CODE $result");

$file = $TGI->filename("tmp:edit");
$TGI->print("FILE NAME $file\n");

exit


