/*********************************************************************/
/*  bibView: Administration of BibTeX-Databases                      */
/*           (Verwaltung von BibTeX-Literaturdatenbanken)            */
/*                                                                   */
/*  Module:  ComboBo.h                                               */
/*                                                                   */
/*             - Combo Box Widget                                    */
/*               Text widget with selection list                     */
/*                                                                   */
/*  Author:  Holger Martin,  martinh@informatik.tu-muenchen.de       */
/*           Peter M. Urban, urban@informatik.tu-muenchen.de         */
/*                                                                   */
/*  History:                                                         */
/*    11.22.91  HM   created                                         */
/*                                                                   */
/*  Copyright 1991 Martin, Urban                                     */
/*    See ./Copyright for complete rights and liability information. */
/*                                                                   */
/*********************************************************************/

#ifndef ComboBox_h
#define ComboBox_h

#define XtNselectCallback "selectCallback"
#define XtNselectMenu "selectMenu"
#define XtNcancelCallback "cancelCallback"
#define XtNmargin "margin"
#define XtNnumberRows "numberRows"
#define XtNshowDotFiles "showDotFiles"
#define XtNbellLevel "bellLevel"
#undef XtNname
#define XtNname "name"             /* NEU: Feldname */
#define XtNrcList "rcList"         /* NEU: Liste    */

extern WidgetClass comboBoxWidgetClass;

typedef struct _ComboBoxRec *ComboBoxWidget;
typedef struct {
    String  directoryPart;
    int     directoryStatus;
    String  filenamePart;
    int     filenameStatus;
} ComboBoxStruct;


typedef struct _RcListNode {                   /* NEU */
                             String data;
                             struct _RcListNode *next;
} RcListNode;


String ComboBoxGetString();
void   ComboBoxSetString();

#endif /* ComboBox_h */
