/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *      November 1985.
 *
 *	%W%	%G%
*/

static short	addpt_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0003, 0x8000, 0x0004, 0x4000, 0x0005, 0x4000, 
		0x0006, 0xC000, 0x0007, 0xC000, 0x0008, 0x2000, 0x0010, 0x1000, 
		0x0020, 0x0800, 0x0041, 0x0400, 0x0083, 0x8200, 0x0105, 0x4100, 
		0x0201, 0x0080, 0x0401, 0x0040, 0x0801, 0x0020, 0x1001, 0x0010, 
		0x2001, 0x0008, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x3FFF, 0xFFF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(addpt_ic, 32, 32, 1, addpt_image);

static short	arc_image[64] = {
		0x0000, 0x0000, 0x0438, 0x0000, 0x0C24, 0x0000, 0x043B, 0x0000, 
		0x0400, 0xC000, 0x0400, 0x2000, 0x0400, 0x1000, 0x0E00, 0x0800, 
		0x0000, 0x0400, 0x0000, 0x0400, 0x0000, 0x0200, 0x0000, 0x0200, 
		0x0000, 0xC100, 0x0001, 0x2100, 0x0000, 0x2280, 0x0000, 0x4280, 
		0x0000, 0x8280, 0x0001, 0x0100, 0x0001, 0xE100, 0x0000, 0x0200, 
		0x0000, 0x0200, 0x0000, 0x0400, 0x0000, 0x0400, 0x0600, 0x0800, 
		0x0900, 0x1000, 0x0100, 0x2000, 0x0600, 0xC000, 0x013B, 0x0000, 
		0x0924, 0x0000, 0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(arc_ic, 32, 32, 1, arc_image);

static short	autoarrow_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 
		0x0001, 0x0000, 0x0001, 0x0000, 0x0003, 0x8000, 0x0003, 0x8000, 
		0x0003, 0x8000, 0x0005, 0x4000, 0x0005, 0x4000, 0x0005, 0x4000, 
		0x0009, 0x2000, 0x0009, 0x2000, 0x0009, 0x2000, 0x0011, 0x1000, 
		0x0011, 0x1000, 0x0011, 0x1000, 0x0021, 0x0800, 0x0021, 0x0800, 
		0x0021, 0x0800, 0x0001, 0x0000, 0x0001, 0x0000, 0x0001, 0x0000, 
		0x0001, 0x0000, 0x0001, 0x0000, 0x0001, 0x0000, 0x0001, 0x0000, 
		0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(autoarrow_ic, 32, 32, 1, autoarrow_image);

static short	backarrow_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0xE000, 
		0x001E, 0x0000, 0x01E0, 0x0000, 0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 
		0x01E0, 0x0000, 0x001E, 0x0000, 0x0001, 0xE000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(backarrow_ic, 32, 32, 1, backarrow_image);

static short	latexline_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7000, 0x001F, 0x8000,
		0x00F0, 0x0000, 0x01EF, 0xC000, 0x0190, 0x3F00, 0x028C, 0x00F0,
		0x0483, 0x0000, 0x0880, 0x8000, 0x0880, 0x6000, 0x1080, 0x1000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x180F, 0xC186, 0x18CF, 0xC0CC, 0x1923, 0x00CC,
		0x1923, 0x0078, 0x19E3, 0x7C30, 0x1923, 0x6030, 0x1923, 0x6078,
		0x1803, 0x60CC, 0x1F83, 0x78CC, 0x1F83, 0x6186, 0x0000, 0x6000,
		0x0000, 0x6000, 0x0000, 0x7C00, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(latexline_ic, 32, 32, 1, latexline_image);

static short	latexarrow_image[64] = {
		0x0000, 0x0000, 0x0000, 0x3C00, 0x0000, 0xF800, 0x001F, 0x3000,
		0x00F0, 0x0000, 0x01EF, 0xC000, 0x0190, 0x3F60, 0x028C, 0x00F0,
		0x0483, 0x40F8, 0x19C0, 0xC000, 0x1DC0, 0xE000, 0x1880, 0xF000,
		0x1080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x180F, 0xC186, 0x18CF, 0xC0CC, 0x1923, 0x00CC,
		0x1923, 0x0078, 0x19E3, 0x7C30, 0x1923, 0x6030, 0x1923, 0x6078,
		0x1803, 0x60CC, 0x1F83, 0x78CC, 0x1F83, 0x6186, 0x0000, 0x6000,
		0x0000, 0x6000, 0x0000, 0x7C00, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(latexarrow_ic, 32, 32, 1, latexarrow_image);

static short	box_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07FF, 0xFFE0,
		0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020,
		0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020,
		0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020,
		0x0400, 0x0020, 0x0400, 0x0020, 0x0400, 0x0020, 0x07FF, 0xFFE0,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(box_ic, 32, 32, 1, box_image);

static short	break_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2AAA, 0xAAA8, 
		0x0000, 0x0000, 0x2000, 0x0008, 0x0000, 0x1C00, 0x2000, 0x6308, 
		0x00F0, 0x8080, 0x210C, 0x8088, 0x0200, 0x8080, 0x2200, 0x6308, 
		0x0100, 0x1C00, 0x20F0, 0x0008, 0x000C, 0x0200, 0x2002, 0x0108, 
		0x0002, 0x0080, 0x2402, 0x0048, 0x0204, 0xFE40, 0x21F8, 0x1048, 
		0x0000, 0x1040, 0x2000, 0x1048, 0x03FC, 0x1080, 0x2204, 0x1108, 
		0x0204, 0x1200, 0x2204, 0x1008, 0x03FC, 0x0000, 0x2000, 0x0008, 
		0x0000, 0x0000, 0x2AAA, 0xAAA8, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(break_ic, 32, 32, 1, break_image);

static short	cirrad_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0xF000, 0x0018, 0x0C00, 
		0x0060, 0x0300, 0x0080, 0x0080, 0x0100, 0x0040, 0x0200, 0x0020, 
		0x0400, 0x0010, 0x0400, 0x0010, 0x0800, 0x0008, 0x0800, 0x0008,
		0x1000, 0x0004, 0x1000, 0x0004, 0x1000, 0x8004, 0x1001, 0xFFFC, 
		0x1000, 0x8004, 0x1000, 0x0004, 0x1000, 0x0004, 0x0800, 0x0008,
		0x0800, 0x0008, 0x0400, 0x0010, 0x0400, 0x0010, 0x0200, 0x0020,
		0x0100, 0x0040, 0x0080, 0x0080, 0x0060, 0x0300, 0x0018, 0x0C00,
		0x0007, 0xF000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(cirrad_ic, 32, 32, 1, cirrad_image);

static short	cirdia_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0xF000, 0x0018, 0x0C00, 
		0x0060, 0x0300, 0x0080, 0x0080, 0x0100, 0x0040, 0x0200, 0x0020, 
		0x0400, 0x0010, 0x0400, 0x0010, 0x0800, 0x0008, 0x0800, 0x0008,
		0x1000, 0x0004, 0x1000, 0x0004, 0x1000, 0x8004, 0x1FFF, 0xFFFC, 
		0x1000, 0x8004, 0x1000, 0x0004, 0x1000, 0x0004, 0x0800, 0x0008,
		0x0800, 0x0008, 0x0400, 0x0010, 0x0400, 0x0010, 0x0200, 0x0020,
		0x0100, 0x0040, 0x0080, 0x0080, 0x0060, 0x0300, 0x0018, 0x0C00,
		0x0007, 0xF000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(cirdia_ic, 32, 32, 1, cirdia_image);

static short	c_spl_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003F, 0xC000,
		0x01C0, 0x3000, 0x0200, 0x0800, 0x0400, 0x0400, 0x0400, 0x0400,
		0x0400, 0x0800, 0x0400, 0x1000, 0x0200, 0x6000, 0x01E1, 0x8000,
		0x001F, 0xF000, 0x0060, 0x0F00, 0x0180, 0x0080, 0x0600, 0x0040,
		0x0800, 0x0020, 0x1000, 0x0020, 0x1000, 0x0020, 0x2000, 0x0020,
		0x2000, 0x0020, 0x2000, 0x0040, 0x1000, 0x0080, 0x1000, 0x0100,
		0x0800, 0x0600, 0x0700, 0x7800, 0x00FF, 0x8000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(c_spl_ic, 32, 32, 1, c_spl_image);

static short	compbegin_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xC000, 
		0x0001, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0002, 0x0000, 0x0004, 0x0000, 0x0018, 0x0000, 
		0x0004, 0x0000, 0x0002, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0001, 0x0000, 0x0000, 0xC000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(compbegin_ic, 32, 32, 1, compbegin_image);

static short	compend_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000C, 0x0000, 
		0x0002, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0001, 0x0000, 0x0000, 0x8000, 0x0000, 0x6000, 
		0x0000, 0x8000, 0x0001, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 
		0x0003, 0x0000, 0x0003, 0x0000, 0x0002, 0x0000, 0x000C, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(compend_ic, 32, 32, 1, compend_image);

static short	copy_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0E00, 0x01C0, 0x1F00, 0x03E0, 0x3180, 0x0630,
		0x6180, 0x0C30, 0x6180, 0x0C30, 0x6180, 0x0C30, 0x60C0, 0x8C18,
		0x60C0, 0xCC18, 0x60DF, 0xEC18, 0x60C0, 0xCC18, 0x60C0, 0x8C18,
		0x6180, 0x0C30, 0x6180, 0x0C30, 0x3180, 0x0630, 0x1980, 0x0330,
		0x0F00, 0x01E0, 0x0600, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(copy_ic, 32, 32, 1, copy_image);

static short	glue_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3FFF, 0xFFF8, 
		0x3FFF, 0xFFF8, 0x3000, 0x0018, 0x3000, 0x1C18, 0x3000, 0x6318, 
		0x30F0, 0x8098, 0x310C, 0x8098, 0x3200, 0x8098, 0x3200, 0x6318, 
		0x3100, 0x1C18, 0x30F0, 0x0018, 0x300C, 0x0218, 0x3002, 0x0118, 
		0x3002, 0x0098, 0x3402, 0x0058, 0x3204, 0xFE58, 0x31F8, 0x1058, 
		0x3000, 0x1058, 0x3000, 0x1058, 0x33FC, 0x1098, 0x3204, 0x1118, 
		0x3204, 0x1218, 0x3204, 0x1018, 0x33FC, 0x0018, 0x3000, 0x0018, 
		0x3FFF, 0xFFF8, 0x3FFF, 0xFFF8, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(glue_ic, 32, 32, 1, glue_image);

static short	dashline_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3E3E, 0x3E3E,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(dashline_ic, 32, 32, 1, dashline_image);

static short	dottedline_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1084, 0x2108,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(dottedline_ic, 32, 32, 1, dottedline_image);

static short	deletept_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0000, 
		0x0250, 0x0000, 0x0130, 0x0000, 0x00B0, 0x0000, 0x0078, 0x0000, 
		0x6074, 0x0000, 0x5852, 0x0000, 0x4699, 0x0000, 0x3194, 0x8000, 
		0x0C72, 0x4000, 0x0319, 0x2000, 0x02C6, 0x9000, 0x0231, 0xC800, 
		0x041C, 0x6800, 0x0413, 0x1C78, 0x0811, 0xFEFC, 0x0810, 0x0FC6, 
		0x1010, 0x06F2, 0x1010, 0x0F3E, 0x2010, 0x0D8C, 0x2010, 0x0CC0, 
		0x4010, 0x0640, 0x4010, 0x0340, 0x0010, 0x01C0, 0x0010, 0x0000, 
		0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		};
mpr_static(deletept_ic, 32, 32, 1, deletept_image);

static short	ellrad_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0xF000, 0x0038, 0x8E00,
		0x00C0, 0x8180, 0x0100, 0x8040, 0x0200, 0x8020, 0x0400, 0x8010,
		0x0800, 0x8008, 0x0800, 0x8008, 0x1000, 0x8004, 0x1001, 0xFFFC,
		0x1000, 0x8004, 0x0800, 0x0008, 0x0800, 0x0008, 0x0400, 0x0010,
		0x0200, 0x0020, 0x0100, 0x0040, 0x00C0, 0x0180, 0x0038, 0x0E00,
		0x0007, 0xF000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(ellrad_ic, 32, 32, 1, ellrad_image);

static short	elldia_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0xF000, 0x0038, 0x8E00,
		0x00C0, 0x8180, 0x0100, 0x8040, 0x0200, 0x8020, 0x0400, 0x8010,
		0x0800, 0x8008, 0x0800, 0x8008, 0x1000, 0x8004, 0x1FFF, 0xFFFC,
		0x1000, 0x8004, 0x0800, 0x8008, 0x0800, 0x8008, 0x0400, 0x8010,
		0x0200, 0x8020, 0x0100, 0x8040, 0x00C0, 0x8180, 0x0038, 0x8E00,
		0x0007, 0xF000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(elldia_ic, 32, 32, 1, elldia_image);

static short	flip_x_image[64] = {
		0x0000, 0x0000, 0x0001, 0x0000, 0x0002, 0x8000, 0x0002, 0x8000, 
		0x0004, 0x4000, 0x0004, 0x4000, 0x0008, 0x2000, 0x0008, 0x2000, 
		0x0010, 0x1000, 0x0010, 0x1000, 0x0020, 0x0800, 0x003E, 0xF800, 
		0x0003, 0x8000, 0x0006, 0xC000, 0x000A, 0xA000, 0x34AB, 0xAD24, 
		0x000A, 0xA000, 0x0006, 0xC000, 0x0003, 0x8000, 0x003E, 0xF800, 
		0x0020, 0x0800, 0x0010, 0x1000, 0x0010, 0x1000, 0x0008, 0x2000, 
		0x0008, 0x2000, 0x0004, 0x4000, 0x0004, 0x4000, 0x0002, 0x8000, 
		0x0002, 0x8000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(flip_x_ic, 32, 32, 1, flip_x_image);

static short	flip_y_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01C0, 0x0700, 
		0x0220, 0x0880, 0x0410, 0x1040, 0x0410, 0x1040, 0x0410, 0x1040, 
		0x0220, 0x0880, 0x0143, 0x8500, 0x0144, 0x4500, 0x0E3F, 0xF8E0, 
		0x1009, 0x2010, 0x261F, 0xF048, 0x4A24, 0x48A4, 0x5223, 0x8894, 
		0x6410, 0x104C, 0x0410, 0x1040, 0x0808, 0x2020, 0x0808, 0x2020, 
		0x1004, 0x4010, 0x1EBC, 0x7AF0, 0x02A0, 0x0A80, 0x02A0, 0x0A80, 
		0x02A0, 0x0A80, 0x02A0, 0x0A80, 0x02A0, 0x0A80, 0x02A0, 0x0A80, 
		0x03E0, 0x0F80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(flip_y_ic, 32, 32, 1, flip_y_image);

static short	forarrow_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x8000, 
		0x0000, 0x7800, 0x0000, 0x0780, 0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 
		0x0000, 0x0780, 0x0000, 0x7800, 0x0007, 0x8000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(forarrow_ic, 32, 32, 1, forarrow_image);

static short	grid1_image[64] = {
		0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410,
		0xFFFF, 0xFFFF, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410,
		0x1041, 0x0410, 0x1041, 0x0410, 0xFFFF, 0xFFFF, 0x1041, 0x0410,
		0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410,
		0xFFFF, 0xFFFF, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410,
		0x1041, 0x0410, 0x1041, 0x0410, 0xFFFF, 0xFFFF, 0x1041, 0x0410,
		0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410,
		0xFFFF, 0xFFFF, 0x1041, 0x0410, 0x1041, 0x0410, 0x1041, 0x0410, };
mpr_static(grid1_ic, 32, 32, 1, grid1_image);

static short	grid2_image[64] = {
		0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0xFFFF, 0xFFFF, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0xFFFF, 0xFFFF, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010,
		0xFFFF, 0xFFFF, 0x1001, 0x0010, 0x1001, 0x0010, 0x1001, 0x0010, };
mpr_static(grid2_ic, 32, 32, 1, grid2_image);

static short	intspl_image[64] = {
		0x0000,0x0000,0x0000,0x0000, 0x0007,0x0000,0x003F,0xC000,
		0x01C7,0x3E00,0x0200,0x0E00, 0x0400,0x0E00,0x0E00,0x0000,
		0x0E00,0x0000,0x0E00,0x0000, 0x0200,0x0000,0x01E3,0x8000,
		0x001F,0xF000,0x0003,0x8F00, 0x0000,0x0080,0x0000,0x0040,
		0x0000,0x0020,0x0000,0x0070, 0x0000,0x0070,0x7000,0x0070,
		0x7000,0x0020,0x7000,0x0040, 0x1000,0x0080,0x1000,0x0100,
		0x0800,0x0600,0x071C,0x7800, 0x00FF,0x8000,0x001C,0x0000,
		0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
		};
mpr_static(intspl_ic, 32, 32, 1, intspl_image);

static short	c_intspl_image[64] = {
		0x0000,0x0000,0x0000,0x0000, 0x000E,0x0000,0x003F,0xC000,
		0x01CE,0x3000,0x0200,0x1C00, 0x0E00,0x1C00,0x0E00,0x1C00,
		0x0E00,0x0800,0x0400,0x1000, 0x0200,0x6000,0x01E1,0xC000,
		0x001F,0xF000,0x0061,0xCF00, 0x0180,0x0080,0x0600,0x0040,
		0x0800,0x0020,0x1000,0x0070, 0x1000,0x0070,0x3800,0x0070,
		0x3800,0x0020,0x3800,0x0040, 0x1000,0x0080,0x1000,0x0100,
		0x0800,0x0600,0x071C,0x7800, 0x00FF,0x8000,0x001C,0x0000,
		0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
		};
mpr_static(c_intspl_ic, 32, 32, 1, c_intspl_image);

static short	line_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0020, 0x0080, 0x0030, 0x00C0, 0x0048, 0x00C0, 0x0048, 0x00A0,
		0x0084, 0x00A0, 0x0084, 0x00A0, 0x0102, 0x0090, 0x0102, 0x0110,
		0x0201, 0x0110, 0x0201, 0x0108, 0x0400, 0x8108, 0x0400, 0x8108,
		0x0801, 0x0100, 0x0802, 0x0200, 0x1004, 0x0200, 0x1008, 0x0200,
		0x0010, 0x0200, 0x0020, 0x0200, 0x0040, 0x0200, 0x00C0, 0x0400,
		0x0030, 0x0800, 0x000C, 0x1000, 0x0003, 0x2000, 0x0000, 0xC000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(line_ic, 32, 32, 1, line_image);

static short	magnet_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x000F, 0xF000, 0x0070, 0x0E00, 
		0x0180, 0x0180, 0x0200, 0x0040, 0x0400, 0x0020, 0x0803, 0xC010, 
		0x0804, 0x2010, 0x1008, 0x1008, 0x1010, 0x0808, 0x1010, 0x0808, 
		0x1010, 0x0808, 0x2020, 0x0404, 0x2020, 0x0404, 0x2020, 0x0404, 
		0x2020, 0x0404, 0x2020, 0x0404, 0x2020, 0x0404, 0x1010, 0x0808, 
		0x1010, 0x0808, 0x1230, 0x0B88, 0x1330, 0x0C48, 0x0AA8, 0x1390, 
		0x0A68, 0x1050, 0x0A28, 0x1450, 0x0624, 0x23A0, 0x0404, 0x2020, 
		0x07FC, 0x3FE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		};
mpr_static(magnet_ic, 32, 32, 1, magnet_image);

static short	unconstraint_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x5F80,
		0x0010, 0x2F80, 0x0040, 0x0780, 0x0000, 0x2340, 0x0100, 0x0060,
		0x0000, 0x4010, 0x0400, 0x0030, 0x0000, 0x4068, 0x0800, 0x01C8,
		0x0000, 0x4708, 0x1000, 0x0E04, 0x0000, 0x981F, 0x1000, 0x700E,
		0x0000, 0xC00E, 0x1000, 0x280E, 0x0000, 0x4204, 0x1000, 0x0084,
		0x0000, 0x1020, 0x0800, 0x0008, 0x0000, 0x0800, 0x0400, 0x0010,
		0x0000, 0x0400, 0x0100, 0x0040, 0x0000, 0x0200, 0x0040, 0x0100,
		0x0010, 0x0400, 0x0005, 0x5000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(unconstraint_ic, 32, 32, 1, unconstraint_image);

static short	mounthattan_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x001F, 0x8000, 0x001F, 0x8000, 0x0019, 0x8000,
		0x0019, 0x8040, 0x0019, 0x80A0, 0x0039, 0xC110, 0x0039, 0xC208,
		0x0130, 0xC404, 0x02B0, 0xC802, 0x0470, 0xD001, 0x0830, 0xE000,
		0x1030, 0xC000, 0x2030, 0xC000, 0x4030, 0xF000, 0x8030, 0xF000,
		0x0030, 0x0000, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(mounthattan_ic, 32, 32, 1, mounthattan_image);

static short	manhattan_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x001F, 0x8000, 0x001F, 0x8000, 0x0019, 0x8000,
		0x0019, 0x8000, 0x0019, 0x800F, 0x0039, 0xC00F, 0x0039, 0xC00C,
		0x0030, 0xC00C, 0x0030, 0xC00C, 0x0030, 0xC00C, 0x3E30, 0xCF8C,
		0x3E30, 0xCF8C, 0x3630, 0xCD8C, 0x3630, 0xFD8C, 0x3630, 0xFD8C,
		0x37F0, 0x018C, 0x37F0, 0x018C, 0x3000, 0x01FC, 0x3000, 0x01FC,
		0xF000, 0x0000, 0xF000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(manhattan_ic, 32, 32, 1, manhattan_image);

static short	mountain_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0C00, 0x0000, 0x1E00, 0x0000, 0x3300, 0x0000,
		0x6180, 0x0000, 0xC0C0, 0x0000, 0x8060, 0x0000, 0x0030, 0x0000,
		0x0018, 0x0018, 0x000C, 0x003C, 0x0006, 0x0066, 0x0003, 0x00C3,
		0x0001, 0x8180, 0x0000, 0xC300, 0x0000, 0x6600, 0x0000, 0x3C00,
		0x0000, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(mountain_ic, 32, 32, 1, mountain_image);

static short	move_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x01C0, 0x0A00, 0x03E0, 0x1000, 0x0630, 
		0x2100, 0x0C30, 0x0000, 0x0C30, 0x2100, 0x0C30, 0x0080, 0x8C18, 
		0x2000, 0xCC18, 0x009F, 0xEC18, 0x2000, 0xCC18, 0x0080, 0x8C18, 
		0x2000, 0x0C30, 0x0100, 0x0C30, 0x1000, 0x0630, 0x0900, 0x0330, 
		0x0200, 0x01E0, 0x0000, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(move_ic, 32, 32, 1, move_image);

static short	change_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x3F80, 0x0000, 0x2080, 0x0CE6,
		0x2080, 0x0802, 0x2080, 0x0802, 0x2080, 0x0000, 0x2081, 0x0000,
		0x2081, 0x8802, 0x20BF, 0xC802, 0x2081, 0x8802, 0x2081, 0x0000,
		0x2080, 0x0000, 0x2080, 0x0802, 0x2080, 0x0802, 0x2080, 0x0CE6,
		0x3F80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(change_ic, 32, 32, 1, change_image);

static short	paste_image[64] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x000F,0xE000,0x007F,0xFC00,
	0x01FF,0xFF00,0x03FF,0xFF80,
	0x07FF,0xFFC0,0x0FFF,0xFFE0,
	0x1FFF,0xFFF0,0x3FFF,0xFFF8,
	0x3FFF,0xFFF8,0x7FFF,0xFFFC,
	0x7FFF,0xF81C,0x7FFF,0xE00C,
	0xFFFF,0xC006,0xFFFF,0x8006,
	0xFE7F,0x8182,0xFC3F,0x03C2,
	0xFC3F,0x03C2,0xFE7E,0x0182,
	0xBFFE,0x0002,0x5FFC,0x0004,
	0x4FF8,0x0004,0x47E0,0x0004,
	0x2000,0x0008,0x2000,0x0008,
	0x1000,0x0010,0x0800,0x0020,
	0x0400,0x0040,0x0200,0x0080,
	0x0180,0x0300,0x0070,0x1C00,
	0x000F,0xE000,0x0000,0x0000,};
mpr_static(paste_ic, 32, 32, 1, paste_image);

static short	align_image[64] = {
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
	0x2121,0x2121,0x2121,0x2121,
	0x2121,0x2121,0x2121,0x2121,
	0x3FFF,0x3FFF,0x2001,0x2001,
	0x2001,0x2001,0x3FFF,0x3FFF,
	0x2121,0x2121,0x2121,0x2121,
	0x2121,0x2121,0x2121,0x2121,
	0xFF3F,0xFF3F,0x0120,0x0120,
	0x0120,0x0120,0xFF3F,0xFF3F,
	0x2121,0x2121,0x2121,0x2121,
	0x2121,0x2121,0x2121,0x2121,
	0x3FFF,0x3FFF,0x2001,0x2001,
	0x2001,0x2001,0x3FFF,0x3FFF,
	0x2121,0x2121,0x2121,0x2121,
	0x2121,0x2121,0x2121,0x2121,
	0xFF3F,0xFF3F,0x0120,0x0120,
	0x0120,0x0120,0xFF3F,0xFF3F,
};
mpr_static(align_ic, 32, 32, 1, align_image);

static short	movept_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0001, 0x03F0,
		0x0000, 0x83F0, 0x03FF, 0xC330, 0x2000, 0x83F0, 0x0001, 0x03F0,
		0x0802, 0x06C0, 0x2000, 0x0CC0, 0x0200, 0x18C0, 0x0000, 0x30C0,
		0x2080, 0x60C0, 0x0000, 0xC0C0, 0x0021, 0x80C0, 0x2003, 0x00C0,
		0x000E, 0x00C0, 0x000C, 0x00C0, 0x201A, 0x00C0, 0x0030, 0x00C0,
		0x0060, 0x80C0, 0x20C0, 0x00C0, 0x0180, 0x20C0, 0x0300, 0x00C0,
		0x2600, 0x08C0, 0x0C00, 0x00C0, 0x1800, 0x02C0, 0x3000, 0x00C0,
		0x0000, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(movept_ic, 32, 32, 1, movept_image);

static short	polygon_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03FF, 0xF800, 
		0x0200, 0x0400, 0x0200, 0x0200, 0x0200, 0x0100, 0x0200, 0x0080, 
		0x0200, 0x0040, 0x0200, 0x0040, 0x0200, 0x0040, 0x0200, 0x0040, 
		0x0200, 0x0040, 0x0200, 0x0080, 0x0200, 0x0100, 0x0200, 0x0200, 
		0x0200, 0x0400, 0x0203, 0xF800, 0x0202, 0x0000, 0x0202, 0x0000, 
		0x0202, 0x0000, 0x0202, 0x0000, 0x0202, 0x0000, 0x0202, 0x0000, 
		0x0202, 0x0000, 0x0202, 0x0000, 0x0202, 0x0000, 0x0202, 0x0000, 
		0x03FE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(polygon_ic, 32, 32, 1, polygon_image);

static short	remove_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0200, 0x0008, 0x4400, 0x0000, 0x0800, 
		0x0021, 0x1004, 0x0000, 0x2008, 0x0084, 0x4010, 0x0000, 0x8021, 
		0x0211, 0x0040, 0x0000, 0x8084, 0x1084, 0x4100, 0x1000, 0x2210, 
		0x1021, 0x1400, 0x1000, 0x0840, 0x1000, 0x0000, 0x1000, 0x0000, 
		0x1000, 0x0400, 0x1000, 0x0300, 0x0800, 0x0080, 0x0800, 0x0080, 
		0x0800, 0x0040, 0x0400, 0x0040, 0x0200, 0x0040, 0x0180, 0x00C0,
		0x0040, 0x0080, 0x0020, 0x0300, 0x001E, 0x1C00, 0x0003, 0xE000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(remove_ic, 32, 32, 1, remove_image);

static short	rot270_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0003, 0x0000, 0x0000, 0xC000, 0x003F, 0xF000, 0x0020, 0xC000, 
		0x0023, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 
		0x0020, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 
		0x0020, 0x0000, 0x0020, 0x0000, 0x0070, 0x0000, 0x00A8, 0x0000, 
		0x0124, 0x0000, 0x013F, 0xFFF0, 0x0104, 0x0010, 0x0088, 0x0010, 
		0x0070, 0x0010, 0x0000, 0x0054, 0x0000, 0x0054, 0x0000, 0x0038, 
		0x0000, 0x0038, 0x0000, 0x0010, 0x0000, 0x0010, 0x0000, 0x0000, };
mpr_static(rot270_ic, 32, 32, 1, rot270_image);

static short	rot90_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0600, 0x0000, 0x1800, 0x0000, 0x7FE0, 0x0000, 0x1820, 0x0000, 
		0x0620, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 
		0x0020, 0x0010, 0x0020, 0x0010, 0x0020, 0x0038, 0x0020, 0x0038, 
		0x0020, 0x0054, 0x0020, 0x0054, 0x0070, 0x0010, 0x00A8, 0x0010, 
		0x0124, 0x0010, 0x013F, 0xFFF0, 0x0104, 0x0000, 0x0088, 0x0000, 
		0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(rot90_ic, 32, 32, 1, rot90_image);

static short	scale_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2AFF, 0xFFF8,
		0x15FF, 0xFFF8, 0x20C0, 0x0018, 0x10C0, 0x1E18, 0x20C0, 0x6198, 
		0x10F0, 0x8058, 0x21CC, 0x8058, 0x12C0, 0x8058, 0x22C0, 0x6198, 
		0x11C0, 0x1E18, 0x20F8, 0x0018, 0x10C4, 0x0218, 0x20C2, 0x0118,
		0x10C2, 0x0098, 0x24C2, 0x0058, 0x12C4, 0xFE58, 0x21F8, 0x1058, 
		0x10C0, 0x1058, 0x20C0, 0x1058, 0x13FF, 0xFFF8, 0x22FF, 0xFFF8, 
		0x1204, 0x1210, 0x2204, 0x1008, 0x13FC, 0x0010, 0x2000, 0x0008, 
		0x1555, 0x5550, 0x2AAA, 0xAAA8, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(scale_ic, 32, 32, 1, scale_image);

static short	turn_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0100, 0x0004, 0x0200, 0x0008, 0x0400, 0x0010, 0x0800, 0x0020, 
		0x1000, 0x0040, 0x1000, 0x0080, 0x2000, 0x0100, 0x2000, 0x0200, 
		0x2000, 0x0400, 0x2000, 0x0800, 0x1000, 0x0400, 0x1000, 0x0200, 
		0x0800, 0x0100, 0x0800, 0x0080, 0x0400, 0x0040, 0x0408, 0x1020, 
		0x0210, 0x0810, 0x023F, 0xFC08, 0x0210, 0x0810, 0x0408, 0x1020, 
		0x0400, 0x0040, 0x0800, 0x0080, 0x1000, 0x0100, 0x2000, 0x0200, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(turn_ic, 32, 32, 1, turn_image);

static short	solidline_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3FFF, 0xFFF8, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(solidline_ic, 32, 32, 1, solidline_image);

static short	spl_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003F, 0xC000,
		0x01C0, 0x3800, 0x0200, 0x0400, 0x0400, 0x0000, 0x0400, 0x0000,
		0x0400, 0x0000, 0x0400, 0x0000, 0x0200, 0x0000, 0x01E0, 0x0000,
		0x001F, 0xF000, 0x0000, 0x0F00, 0x0000, 0x0080, 0x0000, 0x0040,
		0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 0x0020, 0x0000, 0x0020,
		0x2000, 0x0020, 0x2000, 0x0040, 0x1000, 0x0080, 0x1000, 0x0100,
		0x0800, 0x0600, 0x0700, 0x7800, 0x00FF, 0x8000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, };
mpr_static(spl_ic, 32, 32, 1, spl_image);

static short	text_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x07FF, 0xFFE0, 0x0707, 0xE0E0, 0x0603, 0xC060, 0x0403, 0xC020,
		0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000,
		0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000,
		0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000,
		0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000, 0x0003, 0xC000,
		0x0003, 0xC000, 0x0007, 0xE000, 0x001F, 0xF800, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,  };
mpr_static(text_ic, 32, 32, 1, text_image);

static short	zoom_image[64] = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x01FC, 0x0000, 0x0603, 0x0000,
		0x0800, 0x8000, 0x1000, 0x4000, 0x2000, 0x2000, 0x4FE0, 0x1000,
		0x4FE0, 0x1000, 0x8060, 0x0800, 0x80C7, 0x8800, 0x818F, 0xC99A,
		0x830C, 0xCA55, 0x860C, 0xCA55, 0x8C0C, 0xCA55, 0x8FEF, 0xC995,
		0x4FE7, 0x9000, 0x4000, 0x1000, 0x2000, 0x2000, 0x1000, 0x7000,
		0x0800, 0xE800, 0x0603, 0x5400, 0x01FC, 0x2A00, 0x0000, 0x1500,
		0x0000, 0x0A80, 0x0000, 0x0540, 0x0000, 0x02A0, 0x0000, 0x0150,
		0x0000, 0x00A8, 0x0000, 0x0058, 0x0000, 0x0030, 0x0000, 0x0000,  };
mpr_static(zoom_ic, 32, 32, 1, zoom_image);

typedef struct		switch_struct {
				int		on;
				int		group;
				int		x;	/* Row 0 / 1 */
				int		y;	/* Column 0 -> ? */
				struct pixrect	*icon;
				int		value;
				int		(*on_func)();
				int		(*off_func)();
				int		type;
#define						S_TOG		1
#define						S_ON		2
				}
			F_switch;
/*
Switches in the same "group" > -1 are mutually exclusive;
i.e., only one of the switches of the same group can be on at any time.
If a switch in a group n>-1 is on and another one in the same group is
depressed, the former will be turned off and the latter on.
A S_ON switch can not be turned off by clicking at it; it can be turned
off only by clicking another switch in the same group.
A S_TOG switch can be turned off both ways.
No two S_ON or S_ON switches of the same group can be on (hilighted)
at anytime.
Switches with group = -1 are toggle type switches.
*/
