/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *	2nd revision : Feb 1988.
 *
 *	%W%	%G%
*/
#include <pixrect/pixrect_hs.h>
#include <sunwindow/window_hs.h>
#include <suntool/tool_struct.h>
#include <suntool/icon.h>
#include <suntool/window.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <stdio.h>
#include "const.h"
#include "font.h"
#include "paintop.h"
#include "object.h"

extern int		MSG_WIDTH;
extern struct cursor	pencil_cursor;
extern int		errno;
extern int		receiving_msg;
extern int		action_on;
extern			null_proc();
extern Frame		base_frame;
extern Canvas		panel_frame;
extern Canvas		msg_frame;
extern struct pixwin	*msg_pixwin;
extern int		msgswfd;
extern int		DEBUG;

extern char		prefix[], suffix[];
extern int		leng_prefix, leng_suffix;
extern int		cur_x, cur_y;

extern			(*canvas_kbd_proc)();
extern			(*canvas_locmove_proc)();
extern			(*canvas_leftbut_proc)();
extern			(*canvas_middlebut_proc)();
extern			(*canvas_rightbut_proc)();

/*****************  exported  variables and procedures   *****************/

			put_msg();
			init_msgreceiving();

/************************  local variables and routines ******************/

#define			BUF_SIZE		80

static			(*msgsw_kbd_proc)();
static			(*msgsw_leftbut_proc)();
static			(*msgsw_rightbut_proc)();
static			(*recipient)();

static char		msg_received[BUF_SIZE];
static char		prompt[BUF_SIZE];
static int		len_prompt;
static int		base_x = 5, base_y = 18;
static int		input_base_x;

static			msg_selected();

static			(*saved_canvas_kbd_proc)();
static			(*saved_canvas_locmove_proc)();
static			(*saved_canvas_leftbut_proc)();
static			(*saved_canvas_middlebut_proc)();
static			(*saved_canvas_rightbut_proc)();

int
make_msg_frame()
{
	msg_frame = window_create(base_frame, CANVAS,
	    WIN_X,			0,
	    WIN_BELOW,			panel_frame,
	    WIN_WIDTH,			MSG_WIDTH,
	    WIN_HEIGHT,			MSG_HEIGHT,
	    WIN_CURSOR,			&pencil_cursor,
	    WIN_EVENT_PROC,		msg_selected,
	    WIN_CONSUME_KBD_EVENTS,	WIN_ASCII_EVENTS, 0,
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS, 0,
	    CANVAS_FAST_MONO,		TRUE,
	    0);
	if (msg_frame == 0) exit(1);
	msgswfd = window_fd(msg_frame);
	msg_pixwin = canvas_pixwin(msg_frame);
	msgsw_kbd_proc = msgsw_leftbut_proc = msgsw_rightbut_proc = null_proc;
	}

static
msg_selected(win, event)
Window win;
Event  *event;
{
	if (DEBUG)
	    printf("msg_selected: %s code = %d\n",
	      win_inputnegevent(event)? "neg": "pos", event_id(event));

	if (action_on  ||  ! receiving_msg)
	    return;

	if (event->ie_code <= ASCII_LAST)
	    msgsw_kbd_proc(event->ie_code);
	else if (event->ie_code == MS_LEFT)
	    msgsw_leftbut_proc(event->ie_locx, event->ie_locy);
	else if (event->ie_code == MS_RIGHT)
	    msgsw_rightbut_proc(event->ie_locx, event->ie_locy);
	}

put_msg(format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
char   *format, *arg1, *arg2, *arg3, *arg4, *arg5, *arg6, *arg7, *arg8;
{
	clear_message();
	sprintf(prompt, format, arg1, arg2, arg3, arg4, arg5, 
		arg6, arg7, arg8);
	pw_text(msg_pixwin, base_x, base_y, PAINT, bold_font, prompt);
	}

clear_message()
{
	pw_writebackground(msg_pixwin, 0, 0, 2048, 2048, PAINT);
	}

static
end_char_input()
{
	receiving_msg = 0;  /*  msg input has been received  */
	if (! terminate_char_handler()) {
		restore_event_proc();
		return;			/* no characters received */
	}
	strcpy(&prefix[leng_prefix], suffix);
	strcpy(msg_received, prefix);
	strcpy(&prompt[len_prompt], prefix);
	if (recipient != NULL) (* recipient) (msg_received);
	restore_event_proc();
	return;
	}

static
reposition_cursor(x, y)
int	x, y;
{
	int		leng;
	struct pr_size	s;

	strcpy(&prefix[leng_prefix], suffix);
	leng = leng_prefix + leng_suffix; 
	s = pf_textwidth(leng, bold_font, prefix);
	if ( ! (input_base_x <= x && x <= input_base_x+s.x
		&& base_y-s.y <= y && y <= base_y)) {
	    prefix[leng_prefix] = '\0';
	    return;
	    }

	leng_suffix = 0;
	erase_char_string();
	leng_prefix = prefix_length(bold_font, prefix, x-input_base_x);
	strcpy(suffix, &prefix[leng_prefix]);
	prefix[leng_prefix] = '\0';
	leng_suffix = leng - leng_prefix;
	s = pf_textwidth(leng_prefix, bold_font, prefix);
	cur_x = input_base_x + s.x;
	draw_char_string();
	}

init_msg_receiving(msg_recipient, p)
int	(*msg_recipient)();
char	*p;			/* prompt */
{
	extern		char_handler();
	struct pr_size	prompt_size;

	saved_canvas_kbd_proc = canvas_kbd_proc;
	saved_canvas_locmove_proc = canvas_locmove_proc;
	saved_canvas_leftbut_proc = canvas_leftbut_proc;
	saved_canvas_middlebut_proc = canvas_middlebut_proc;
	saved_canvas_rightbut_proc = canvas_rightbut_proc;

	receiving_msg = 1;
	msgsw_kbd_proc = char_handler;
	msgsw_leftbut_proc = reposition_cursor;
	canvas_kbd_proc = char_handler;
	canvas_locmove_proc = null_proc;
	canvas_leftbut_proc = null_proc;
	canvas_rightbut_proc = null_proc;
	recipient = msg_recipient;
	blink_msg();
	clear_message();
	strcpy(prompt, p);
	pw_text(msg_pixwin, base_x, base_y, PAINT, bold_font, prompt);

	len_prompt = strlen(prompt);
	prompt_size = pf_textwidth(len_prompt, bold_font, prompt);
	cur_x = input_base_x = base_x + prompt_size.x;
	cur_y = base_y;
	leng_prefix = leng_suffix = 0;
	*prefix = *suffix = '\0';
	initialize_char_handler(msg_pixwin, bold_font, end_char_input, cur_x, base_y, T_LEFT_JUSTIFIED);
	}

restore_event_proc()
{
	canvas_kbd_proc = saved_canvas_kbd_proc;
	canvas_locmove_proc = saved_canvas_locmove_proc;
	canvas_leftbut_proc = saved_canvas_leftbut_proc;
	canvas_middlebut_proc = saved_canvas_middlebut_proc;
	canvas_rightbut_proc = saved_canvas_rightbut_proc;
	}

blink_msg()
{
	int	i;

	pw_writebackground(msg_pixwin, 0, 0, 2048, 2048, ERASE);
	for (i = 0; i < 2000; i++);
	clear_message();
	}
