/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <pixrect/pixrect_hs.h>
#include <sunwindow/window_hs.h>
#include <suntool/tool_struct.h>
#include <suntool/icon.h>
#include <suntool/window.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <stdio.h>
#include <sys/stat.h>
#include "const.h"
#include "version.h"

extern Frame		base_frame;
extern Canvas		panel_frame;
extern Canvas		canvas_frame;
extern Canvas		msg_frame;
extern Canvas		sideruler_frame;
extern Canvas		topruler_frame;

extern int		PANL_HEIGHT, PANL_WID;
extern int		MSG_WIDTH;
extern int		SIDERULER_WIDTH, SIDERULER_HEIGHT;
extern int		SIDERULER_START;
extern int		TOPRULER_WIDTH, TOPRULER_HEIGHT;
extern int		figure_modified;
extern char		directory[], current_file[];
extern			(*canvas_rightbut_proc)();
extern			set_popupmenu();

#include "fig.icon"

#define 		FIG_ICON_WIDTH		MY_ICON_WIDTH
#define 		FIG_ICON_HEIGHT		MY_ICON_HEIGHT
#define			SCREEN_WIDTH		1152
#define			SCREEN_HEIGHT		900
#define			min(a,b)		(((a) < (b)) ? (a) : (b))

mpr_static(fig_icon_pr, FIG_ICON_WIDTH, FIG_ICON_HEIGHT, 1, icon_data);
static struct icon	fig_icon  =  {
				FIG_ICON_WIDTH+4, FIG_ICON_HEIGHT+4, NULL,
				{2, 2, FIG_ICON_WIDTH, FIG_ICON_HEIGHT},
				&fig_icon_pr, {0, 0, 0, 0}, NULL, NULL,
				ICON_BKGRDSET };


/************** FIG options ******************/

extern int		DEBUG;
extern int		RHS_PANL;
extern int		INVERSE;

struct tool		*tool;
int			WINDOW_WIDTH, WINDOW_HEIGHT;
char			file_header[32] = "#FIG ";
static char		*file = NULL;

get_args(argc, argv)
int	argc;
char	**argv;
{
	char	*option;

	while (--argc > 0)  {
	    option = *++argv;
	    if (*option == '-') {
		option++;
		if (*option == 'r') {		/* option -r */
		    RHS_PANL = 1;
		    }
		else if (*option == 'd') {	/* option -d */
		    DEBUG = 1;
		    }
		else if (*option == 'i') {	/* option -i */
		    INVERSE = 1;
		    invert_color();
		    }
		}
	    else {
		file = option;
		}
	    }
	}

set_frame_label()
{
	char	label[256];

	(void)sprintf(label, "FIG %s  -  %s%s,  dir: %s",
	  FIG_VERSION,
	  (*current_file == '\0')? "NO FILE": current_file,
	  figure_modified? " [modified]": "",
	  directory);
	window_set(base_frame, FRAME_LABEL, label, 0);
	}

static
make_base_frame(argc, argv)
int	*argc;
char	**argv;
{
	base_frame = window_create((Window)0, FRAME,
	    WIN_X,			    240, /* 3 inches to 
                                                  * account for the 
                                                  * larger frame */
	    WIN_Y,			    0,
	    FRAME_SUBWINDOWS_ADJUSTABLE,    FALSE,
	    FRAME_ICON,			    &fig_icon,
	    FRAME_ARGC_PTR_ARGV,	    argc,argv,
	    0);
 	if (base_frame == NULL) exit(1);
       }

main(argc, argv)
int	argc;
char	**argv;
{
	make_base_frame(&argc, argv);

	get_args(argc, argv);
	strcat(file_header, FIG_SEMANTICS);
	/* printf("Initializing FIG %s ... \n", FIG_VERSION); */
	compute_window_sizes();
	init_font();

	if (RHS_PANL) {
	    make_sideruler_frame(NULL);
	    make_topruler_frame(sideruler_frame);
	    make_canvas_frame(sideruler_frame);
	    make_panel_frame(canvas_frame);
	    }
	else {
	    make_panel_frame(NULL);
	    make_topruler_frame(panel_frame);
	    make_canvas_frame(panel_frame);
	    make_sideruler_frame(canvas_frame);
	    }
	make_msg_frame();
	make_change_frame();
	make_align_frame();
	(void)window_fit(base_frame);

	(void)getwd(directory);
	if (file != NULL) {
	    edit_file(file);
	    }
	set_frame_label();
	init_popupmenu();
	canvas_rightbut_proc = set_popupmenu;
	
	window_main_loop(base_frame);
	}

#define		TOPRULER_CANVS_SPACING		5
#define		SIDERULER_CANVS_SPACING		5
#define		PANL_CANVS_SPACING		5
#define		PANL_MSG_SPACING		5
#define		borderwid			5
#define		windowspacing			5
#define		toolstripeht			16

compute_window_sizes()
{
	PANL_WID = ICON_COLUMN * SWITCH_ICON_WIDTH;
	PANL_HEIGHT = RULER_WIDTH + CANVS_HEIGHT + TOPRULER_CANVS_SPACING;

	MSG_WIDTH = PANL_WID + RULER_WIDTH + CANVS_WIDTH
		+ SIDERULER_CANVS_SPACING + PANL_CANVS_SPACING;
	/* MSG_HEIGHT is defined in const.h */

	TOPRULER_WIDTH = CANVS_WIDTH;
	TOPRULER_HEIGHT = RULER_WIDTH;

	SIDERULER_WIDTH = RULER_WIDTH;
	SIDERULER_HEIGHT = PANL_HEIGHT;
	SIDERULER_START = RULER_WIDTH + TOPRULER_CANVS_SPACING;

	WINDOW_WIDTH = borderwid + MSG_WIDTH + borderwid;
	WINDOW_HEIGHT = toolstripeht + 2 + PANL_HEIGHT 
	    + PANL_MSG_SPACING + MSG_HEIGHT + borderwid;

	}
