


XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



NAME
     xdvi - DVI Previewer for the X Window System

SYNOPSIS
     xdvi  [+[page]]  [-s  shrink]  [-S  density]   [-p   pixels]
     [-altfont  font]  [-l]  [-rv]  [-fg  color] [-bg color] [-hl
     color] [-bd color] [-cr color] [-thorough] [-margins inches]
     [-sidemargin  inches]  [-topmargin  inches]  [-mgs[n]  size]
     [-geometry  geometry  |  =geometry]  [%geometry]   [-display
     display] file

DESCRIPTION
     Xdvi is a program which runs under the X window  system.  It
     is used to preview DVI files, such as are produced by TeX.

     This program has the capability of showing the file shrunken
     by  various  (integer)  factors, and also has a ``magnifying
     glass'' which allows one to see a small part of the unshrunk
     image momentarily.

     Also, before displaying any page or part thereof, it  checks
     to  see  if  the dvi file has changed since the last time it
     was displayed.  If this is the case, then xdvi  will  reini-
     tialize  itself  for the new dvi file.  For this reason, ex-
     posing parts of the xdvi window while TeX is running  should
     be  avoided.   This  feature allows you to preview many ver-
     sions of the same file while running xdvi only once.

OPTIONS
     In addition to specifying the .dvi file (with or without the
     .dvi), Xdvi supports the following command line options.  If
     the option begins with a `+' instead of a `-', the option is
     restored  to  its  default value.  By default, these options
     can be set via the resource names given  in  parentheses  in
     the description of each option.

     +page
          Specifies the first  page  to  show.   If  +  is  given
          without  a  number, the last page is assumed; the first
          page is the default.

     -s shrink
          (.shrinkFactor) Defines the initial shrink factor.  The
          default value is 3.

     -S density
          (.densityPercent)  Determines  the  density  used  when
          shrinking bitmaps for fonts.  A higher value produces a
          lighter font.  The default value is 40.

     -p pixels
          (.pixelsPerInch) Defines the size of the fonts to  use,



X Version 11         Last change: 8 May 1989                    1






XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



          in pixels per inch.  The default value is 300.

     -altfont font
          (.altFont) Declares a default font to use when the font
          in  the  dvi file cannot be found.  This is useful, for
          example, with PostScript <tm> fonts.

     -l   (.listFonts) Causes the names of the fonts used  to  be
          listed.

     -rv  (.reverseVideo) Causes the page to  be  displayed  with
          white characters on a black background, instead of vice
          versa.

     -bw width
          (.borderWidth) Specifies the width of the border of the
          window.

     -borderwidth width
          Same as -bw, above.

     -fg color
          (.foreground) Determines the color of the  text  (fore-
          ground).

     -foreground color
          Same as -fg, above.

     -bg color
          (.background) Determines the color of the background.

     -background color
          Same as -bg, above.

     -hl color
          (.highlight) Determines the color of the page border.

     -bd color
          (.borderColor) Determines the color of the window bord-
          er.

     -cr color
          (.cursorColor) Determines the color of the cursor.  The
          default is the foreground color.

     -thorough
          (.thorough) Xdvi will usually try to ensure that  over-
          strike characters (e.g.  \notin) are printed correctly.
          On monochrome displays, this is  always  possible  with
          one  logical  operation,  either  and  or or.  On color
          displays, however, this may take two operations, one to
          set  the  appropriate bits and one to clear other bits.



X Version 11         Last change: 8 May 1989                    2






XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



          If this is the case, then by default xdvi will  instead
          use  the  copy  operation,  which does not handle over-
          striking correctly.  The  ``thorough''  option  chooses
          the slower but more correct choice.

     -margins inches
          (.margins) Specifies the size of both  the  top  margin
          and  side  margin.  This can be a decimal number, e.g.,
          1.5.  It determines the ``home'' position of  the  page
          within  the window as follows.  If the entire page fits
          in the window, then the margin  settings  are  ignored.
          If,  even  after  removing  the  margins from the left,
          right, top, and bottom, the page still  cannot  fit  in
          the  window,  then  the  page is put in the window such
          that the top and left margins are hidden,  and  presum-
          ably the upper left-hand corner of the text on the page
          will be in the upper left-hand corner  of  the  window.
          Otherwise,  the  text  is  centered in the window.  See
          also `H' under the KEYSTROKES section.

     -sidemargin inches
          (.sideMargin) Specifies the side margin (see above).

     -topmargin inches
          (.topMargin) Specifies the top and bottom margins  (see
          above).

     -mgs[n] size
          (.magnifierSize[n]) Specifies the size of the window to
          be used for the ``magnifying glass'' for Button n.  See
          the MOUSE ACTIONS section.  Defaults are 200, 350, 600,
          900, and 1200.

     -mgs size
          Same as -mgs1, above.

     =geometry
          (*geometry) Specifies the initial geometry of the  win-
          dow.

     -geometry geometry
          Same as above.

     #geometry
          (.iconGeometry) Specifies the initial position for  the
          icon.

     -display host:display
          Specifies the host and screen to be used for displaying
          the  dvi  file.  This is normally obtained from the en-
          vironment variable ``DISPLAY.''




X Version 11         Last change: 8 May 1989                    3






XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



KEYSTROKES
     Xdvi recognizes the following keystrokes when typed  in  its
     window.   Each  may optionally be preceded by a (positive or
     negative) number, whose interpretation will  depend  on  the
     particular keystroke.

     q    Quits the program.  Control-C  and  control-D  will  do
          this, too.

     n    Moves to the next page (or to the nth next  page  if  a
          number is given).  Synonyms are `f', Space, Return, and
          Line Feed.

     p    Moves to the previous page (or back n pages).  Synonyms
          are `b', control-H, and Delete.

     g    Moves to the page with the  given  number.   Initially,
          the first page is assumed to be page number 1, but this
          can be changed with the `P' keystroke,  below.   If  no
          page number is given, then it goes to the last page.

     P    ``This is page number n.''  This can be  used  to  make
          the  `g' keystroke refer to actual page numbers instead
          of absolute page numbers.

     Control-L
          Redisplays the current page.

     ^    Move to the ``home'' position of  the  page.   This  is
          normally  the  upper  left-hand  corner  of  the  page,
          depending on the margins as described in  the  -margins
          option, above.

     u    Moves up a window-full.

     d    Moves down a window-full.

     l    Moves left a window-full.

     r    Moves right a window-full.

     c    Moves the page so that the point currently beneath  the
          cursor  is  moved to the middle of the window.  It also
          (gasp!) warps the cursor to the same place.

     M    Sets the margins so that the point currently under  the
          cursor is the upper left-hand corner of the text in the
          page.

     s    Changes the shrink factor to the given number.   If  no
          number is given, the smallest factor that makes the en-
          tire page fit in the window will be used.  (Margins are



X Version 11         Last change: 8 May 1989                    4






XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



          ignored in this computation.)

     S    Sets the density factor to be used when shrinking  bit-
          maps.   This  should  be  a  number  between 0 and 100;
          higher numbers produce lighter characters.

     R    Forces the dvi file to be reread.  This allows  you  to
          preview  many  versions  of the same file while running
          xdvi only once.

MOUSE ACTIONS
     If the shrink factor is set to any number  other  than  one,
     then  clicking  any  mouse button will pop up a ``magnifying
     glass'' which shows the unshrunk image in  the  vicinity  of
     the  mouse  click.  This subwindow disappears when the mouse
     button is released.  Different mouse  buttons  produce  dif-
     ferent  sized  windows,  as  indicated  by  the -mgs option,
     above.

     Also, the scrollbars (if present)  behave  in  the  standard
     way:   pushing Button 2 in a scrollbar moves the top or left
     edge of the scrollbar to that point; pushing Button 1  moves
     the  image  up  or  right by an amount equal to the distance
     from the button press to the upper left-hand corner  of  the
     window; pushing Button 3 moves the image down or left by the
     same amount.

ENVIRONMENT
     Uses the environment variable ``DISPLAY'' to  specify  which
     bit map display terminal to use.

     The environment variable ``TEXPKS'' determines  the  path(s)
     searched for fonts in the following manner.  The string con-
     sists of one or more strings separated by colons.   In  each
     such  string,  the  substring  ``%f'' is changed to the font
     name; ``%d'' is changed to the magnification; and ``%p''  is
     changed to the font family (``gf'', ``pk'', or ``pxl'').  If
     no  ``%f''  appears  in  the   string,   then   the   string
     ``/%f.%d%p''  is  added  on  the  end.   For example, if the
     string is ``/usr/local/tex/fonts'' and the font is cmr10  at
     300dpi,         then         it         searches         for
     /usr/local/tex/fonts/cmr10.300gf,
     /usr/local/tex/fonts/cmr10.300pk,                        and
     /usr/local/tex/fonts/cmr10.1500pxl, in that order.   If  the
     first  character of the ``TEXPKS'' variable is a colon, then
     the system default paths are tried first.

FILES
     /usr/local/lib/tex/fonts/pk   Font pixel files.

SEE ALSO
     X(1).



X Version 11         Last change: 8 May 1989                    5






XDVI(SIPB)        MISC. REFERENCE MANUAL PAGES         XDVI(SIPB)



AUTHORS
     Eric Cooper, CMU, did a version for direct output to a QVSS.
     Modified for X by Bob Scheifler, MIT Laboratory for Computer
     Science.  Modified for X11 by Mark Eichin, MIT SIPB.   Addi-
     tional enhancements by many others.


















































X Version 11         Last change: 8 May 1989                    6



