# Introduction

**[`bindgen`](https://github.com/rust-lang/rust-bindgen) automatically generates Rust
FFI bindings to C and C++ libraries.**

For example, given the C header `cool.h`:

```c
typedef struct CoolStruct {
    int x;
    int y;
} CoolStruct;

void cool_function(int i, char c, CoolStruct* cs);
```

`bindgen` produces Rust FFI code allowing you to call into the `cool` library's
functions and use its types:

```rust
/* automatically generated by rust-bindgen 0.99.9 */

#[repr(C)]
pub struct CoolStruct {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}

extern "C" {
    pub fn cool_function(i: ::std::os::raw::c_int,
                         c: ::std::os::raw::c_char,
                         cs: *mut CoolStruct);
}
```
